/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.WriteCSVMR;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.CSVReblockReducer;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.transform.ApplyTfBBMapper;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ApplyTfBBMR {
    public static JobReturn runJob(String inputPath, String rblkInst, String otherInst, String spec, String mapsPath, String tmpPath, String outputPath, String partOffsetsFile, CSVFileFormatProperties inputDataProperties, long numRows, long numColsBefore, long numColsAfter, int replication, String headerLine) throws Exception {
        CSVReblockInstruction rblk = (CSVReblockInstruction)InstructionParser.parseSingleInstruction(rblkInst);
        long[] rlens = new long[]{numRows};
        long[] clens = new long[]{numColsAfter};
        int[] brlens = new int[]{rblk.brlen};
        int[] bclens = new int[]{rblk.bclen};
        byte[] realIndexes = new byte[]{rblk.input};
        byte[] resultIndexes = new byte[]{rblk.output};
        JobConf job = new JobConf(ApplyTfBBMR.class);
        job.setJobName("ApplyTfBB");
        job.setJarByClass(ApplyTfBBMR.class);
        job.setMapperClass(ApplyTfBBMapper.class);
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, new String[]{inputPath}, new InputInfo[]{InputInfo.CSVInputInfo}, brlens, bclens, false, MRJobConfiguration.ConvertTarget.CELL);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, rlens, clens);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
        MRJobConfiguration.setCSVReblockInstructions(job, rblkInst);
        MRJobConfiguration.setInstructionsInReducer(job, otherInst);
        job.setInt("dfs.replication", replication);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, null, rblkInst, null, otherInst, resultIndexes);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, null, rblkInst, null, null, null, resultIndexes, mapoutputIndexes, false);
        int numRed = WriteCSVMR.determineNumReducers(rlens, clens, ConfigurationManager.getNumReducers(), ret.numReducerGroups);
        job.setNumReduceTasks(numRed);
        MRJobConfiguration.setUpMultipleOutputs(job, new byte[]{rblk.output}, new byte[]{0}, new String[]{outputPath}, new OutputInfo[]{OutputInfo.BinaryBlockOutputInfo}, true, false);
        job.setMapperClass(ApplyTfBBMapper.class);
        job.setMapOutputKeyClass(TaggedFirstSecondIndexes.class);
        job.setMapOutputValueClass(CSVReblockMR.BlockRow.class);
        job.setReducerClass(CSVReblockReducer.class);
        job.setBoolean("adaptivemr.map.enable", false);
        MRJobConfiguration.setUniqueWorkingDir(job);
        DistributedCache.addCacheFile((URI)new Path(mapsPath).toUri(), (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        Path cachefile = new Path(new Path(partOffsetsFile), "part-00000");
        DistributedCache.addCacheFile((URI)cachefile.toUri(), (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        job.set("transform.has.header", Boolean.toString(inputDataProperties.hasHeader()));
        job.set("transform.field.delimiter", inputDataProperties.getDelim());
        if (inputDataProperties.getNAStrings() != null) {
            job.set("transform.na.strings", TfUtils.prepNAStrings(inputDataProperties.getNAStrings()));
        }
        job.set("transform.specification", spec);
        job.set("transform.smallest.file", CSVReblockMR.findSmallestFile(job, inputPath));
        job.set("output.matrices.dirs", outputPath);
        job.setLong("transform.num.columns", numColsBefore);
        job.set("transform.txmtd.path", mapsPath);
        job.set("transform.header.line", headerLine);
        job.set("rowid.file.name", cachefile.toString());
        job.set("transform.temp.location", tmpPath);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        MapReduceTool.deleteFileIfExistOnHDFS(cachefile, job);
        Counters.Group group = runjob.getCounters().getGroup("nonzeros");
        for (int i = 0; i < resultIndexes.length; ++i) {
            ret.stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
        }
        return new JobReturn(ret.stats, runjob.isSuccessful());
    }
}

