/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.AdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.PartialBlock;
import org.apache.sysml.runtime.matrix.data.TaggedAdaptivePartialBlock;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.matrix.mapred.ReblockBuffer;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ReblockMapper
extends MapperBase
implements Mapper<Writable, Writable, Writable, Writable> {
    private OutputCollector<Writable, Writable> cachedCollector = null;
    private JobConf cachedJobConf = null;
    private HashMap<Byte, MatrixCharacteristics> dimensionsOut = new HashMap();
    private HashMap<Byte, MatrixCharacteristics> dimensionsIn = new HashMap();
    private HashMap<Byte, Boolean> emptyBlocks = new HashMap();
    private HashMap<Byte, ReblockBuffer> buffer = new HashMap();
    private int buffersize = -1;

    public void map(Writable rawKey, Writable rawValue, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.cachedCollector = out;
        this.commonMap(rawKey, rawValue, out, reporter);
    }

    @Override
    public void configure(JobConf job) {
        MRJobConfiguration.setMatrixValueClass(job, false);
        super.configure(job);
        this.cachedJobConf = job;
        try {
            ReblockInstruction[] reblockInstructions;
            for (ReblockInstruction ins : reblockInstructions = MRJobConfiguration.getReblockInstructions(job)) {
                this.dimensionsIn.put(ins.input, MRJobConfiguration.getMatrixCharacteristicsForInput(job, ins.input));
                this.dimensionsOut.put(ins.output, MRJobConfiguration.getMatrixCharactristicsForReblock(job, ins.output));
                this.emptyBlocks.put(ins.output, ins.outputEmptyBlocks);
            }
            int maxlen = 1;
            for (ArrayList rinst : this.reblock_instructions) {
                maxlen = Math.max(maxlen, rinst.size());
            }
            this.buffersize = 5000000 / maxlen;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        for (Map.Entry<Byte, ReblockBuffer> e : this.buffer.entrySet()) {
            ReblockBuffer rbuff = e.getValue();
            rbuff.flushBuffer(e.getKey(), this.cachedCollector);
        }
        if (this.cachedJobConf == null || this.cachedCollector == null) {
            return;
        }
        long mapID = Long.parseLong(MapReduceTool.getUniqueKeyPerTask(this.cachedJobConf, true));
        long numMap = this.cachedJobConf.getNumMapTasks();
        MatrixIndexes tmpIx = new MatrixIndexes();
        TaggedAdaptivePartialBlock tmpVal = new TaggedAdaptivePartialBlock();
        AdaptivePartialBlock apb = new AdaptivePartialBlock(new PartialBlock(-1, -1, 0.0));
        tmpVal.setBaseObject(apb);
        for (Map.Entry<Byte, MatrixCharacteristics> e : this.dimensionsOut.entrySet()) {
            tmpVal.setTag(e.getKey());
            MatrixCharacteristics mc = e.getValue();
            long rlen = mc.getRows();
            long clen = mc.getCols();
            long brlen = mc.getRowsPerBlock();
            long bclen = mc.getColsPerBlock();
            long nnz = mc.getNonZeros();
            if (nnz >= rlen * clen - Math.min(brlen, rlen) * Math.min(bclen, clen) + 1L || !this.emptyBlocks.get(e.getKey()).booleanValue()) continue;
            long numBlocks = (long)Math.ceil((double)rlen / (double)brlen);
            long len = (long)Math.ceil((double)numBlocks / (double)numMap);
            long start = mapID * len * brlen;
            long end = Math.min((mapID + 1L) * len * brlen, rlen);
            long i = start;
            long r = start / brlen + 1L;
            while (i < end) {
                long j = 0L;
                long c = 1L;
                while (j < clen) {
                    tmpIx.setIndexes(r, c);
                    this.cachedCollector.collect((Object)tmpIx, (Object)tmpVal);
                    j += bclen;
                    ++c;
                }
                i += brlen;
                ++r;
            }
        }
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.processMapperInstructionsForMatrix(index);
        this.processReblockInMapperAndOutput(index, out);
    }

    protected void processReblockInMapperAndOutput(int index, OutputCollector<Writable, Writable> out) throws IOException {
        for (ReblockInstruction ins : (ArrayList)this.reblock_instructions.get(index)) {
            ArrayList<IndexedMatrixValue> ixvList = this.cachedValues.get(ins.input);
            if (ixvList == null) continue;
            for (IndexedMatrixValue inValue : ixvList) {
                MatrixValue mval;
                if (inValue == null) continue;
                ReblockBuffer rbuff = this.buffer.get(ins.output);
                if (rbuff == null) {
                    MatrixCharacteristics mc = this.dimensionsOut.get(ins.output);
                    rbuff = new ReblockBuffer(this.buffersize, mc.getRows(), mc.getCols(), ins.brlen, ins.bclen);
                    this.buffer.put(ins.output, rbuff);
                }
                if ((mval = inValue.getValue()) instanceof MatrixBlock) {
                    MatrixIndexes inIx = inValue.getIndexes();
                    MatrixCharacteristics mc = this.dimensionsIn.get(ins.input);
                    long row_offset = (inIx.getRowIndex() - 1L) * (long)mc.getRowsPerBlock() + 1L;
                    long col_offset = (inIx.getColumnIndex() - 1L) * (long)mc.getColsPerBlock() + 1L;
                    rbuff.appendBlock(row_offset, col_offset, (MatrixBlock)mval, ins.output, out);
                    continue;
                }
                rbuff.appendCell(inValue.getIndexes().getRowIndex(), inValue.getIndexes().getColumnIndex(), ((MatrixCell)mval).getValue());
                if (rbuff.getSize() < rbuff.getCapacity()) continue;
                rbuff.flushBuffer(ins.output, out);
            }
        }
    }
}

