/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.data.TripleIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;

public class MMRJMRReducer
extends ReduceBase
implements Reducer<TripleIndexes, TaggedMatrixValue, MatrixIndexes, MatrixValue> {
    private Reporter cachedReporter = null;
    private MatrixValue resultblock = null;
    private MatrixIndexes aggIndexes = new MatrixIndexes();
    private TripleIndexes prevIndexes = new TripleIndexes(-1L, -1L, -1L);
    protected AggregateBinaryInstruction[] aggBinInstructions = null;

    public void reduce(TripleIndexes triple, Iterator<TaggedMatrixValue> values, OutputCollector<MatrixIndexes, MatrixValue> out, Reporter report) throws IOException {
        long start = System.currentTimeMillis();
        this.commonSetup(report);
        if (this.prevIndexes.getFirstIndex() != triple.getFirstIndex() || this.prevIndexes.getSecondIndex() != triple.getSecondIndex()) {
            this.processReducerInstructions();
            this.outputResultsFromCachedValues(report);
            this.cachedValues.reset();
        } else {
            for (AggregateBinaryInstruction aggBinInstruction : this.aggBinInstructions) {
                this.cachedValues.remove(aggBinInstruction.input1);
                this.cachedValues.remove(aggBinInstruction.input2);
            }
        }
        this.aggIndexes.setIndexes(triple.getFirstIndex(), triple.getSecondIndex());
        this.processAggregateInstructions(this.aggIndexes, values);
        for (AggregateBinaryInstruction aggBinInstruction : this.aggBinInstructions) {
            this.processAggBinaryPerGroup(this.aggIndexes, aggBinInstruction);
        }
        this.prevIndexes.setIndexes(triple);
        report.incrCounter((Enum)ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    private void processAggBinaryPerGroup(MatrixIndexes indexes, AggregateBinaryInstruction aggBinInstruction) throws IOException {
        IndexedMatrixValue left = this.cachedValues.getFirst(aggBinInstruction.input1);
        IndexedMatrixValue right = this.cachedValues.getFirst(aggBinInstruction.input2);
        if (left != null && right != null) {
            try {
                this.resultblock = left.getValue().aggregateBinaryOperations(left.getValue(), right.getValue(), this.resultblock, (AggregateBinaryOperator)aggBinInstruction.getOperator());
                IndexedMatrixValue out = this.cachedValues.getFirst(aggBinInstruction.output);
                if (out == null) {
                    out = this.cachedValues.holdPlace(aggBinInstruction.output, this.valueClass);
                    out.getIndexes().setIndexes(indexes);
                    OperationsOnMatrixValues.startAggregation(out.getValue(), null, ((AggregateBinaryOperator)aggBinInstruction.getOperator()).aggOp, this.resultblock.getNumRows(), this.resultblock.getNumColumns(), this.resultblock.isInSparseFormat(), false);
                }
                OperationsOnMatrixValues.incrementalAggregation(out.getValue(), null, this.resultblock, ((AggregateBinaryOperator)aggBinInstruction.getOperator()).aggOp, false);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        long start = System.currentTimeMillis();
        this.processReducerInstructions();
        this.outputResultsFromCachedValues(this.cachedReporter);
        if (this.cachedReporter != null) {
            this.cachedReporter.incrCounter((Enum)ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
        }
        super.close();
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.aggBinInstructions = MRJobConfiguration.getAggregateBinaryInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
    }
}

