/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Divide;
import org.apache.sysml.runtime.functionobjects.Equals;
import org.apache.sysml.runtime.functionobjects.GreaterThan;
import org.apache.sysml.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysml.runtime.functionobjects.LessThan;
import org.apache.sysml.runtime.functionobjects.LessThanEquals;
import org.apache.sysml.runtime.functionobjects.Minus;
import org.apache.sysml.runtime.functionobjects.MinusMultiply;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Multiply2;
import org.apache.sysml.runtime.functionobjects.NotEquals;
import org.apache.sysml.runtime.functionobjects.Or;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.functionobjects.Power2;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.matrix.data.LibMatrixOuterAgg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlockFactory;
import org.apache.sysml.runtime.matrix.data.SparseRow;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.SortUtils;

public class LibMatrixBincell {
    private LibMatrixBincell() {
    }

    public static void bincellOp(MatrixBlock m1, MatrixBlock ret, ScalarOperator op) throws DMLRuntimeException {
        if (op.sparseSafe && m1.isInSparseFormat() != ret.isInSparseFormat() || !op.sparseSafe && ret.isInSparseFormat()) {
            throw new DMLRuntimeException("Wrong output representation for safe=" + op.sparseSafe + ": " + m1.isInSparseFormat() + ", " + ret.isInSparseFormat());
        }
        if (op.sparseSafe) {
            LibMatrixBincell.safeBinaryScalar(m1, ret, op);
        } else {
            LibMatrixBincell.unsafeBinaryScalar(m1, ret, op);
        }
        if (ret.isEmptyBlock(false)) {
            ret.examSparsity();
        }
    }

    public static void bincellOp(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        if (op.sparseSafe || LibMatrixBincell.isSparseSafeDivide(op, m2)) {
            LibMatrixBincell.safeBinary(m1, m2, ret, op);
        } else {
            LibMatrixBincell.unsafeBinary(m1, m2, ret, op);
        }
        if (ret.isEmptyBlock(false)) {
            ret.examSparsity();
        }
    }

    public static void bincellOpInPlace(MatrixBlock m1ret, MatrixBlock m2, BinaryOperator op) throws DMLRuntimeException {
        if (op.sparseSafe || LibMatrixBincell.isSparseSafeDivide(op, m2)) {
            LibMatrixBincell.safeBinaryInPlace(m1ret, m2, op);
        } else {
            LibMatrixBincell.unsafeBinaryInPlace(m1ret, m2, op);
        }
        if (m1ret.isEmptyBlock(false)) {
            m1ret.examSparsity();
        }
    }

    public static BinaryAccessType getBinaryAccessType(MatrixBlock m1, MatrixBlock m2) {
        int rlen1 = m1.rlen;
        int rlen2 = m2.rlen;
        int clen1 = m1.clen;
        int clen2 = m2.clen;
        if (rlen1 == rlen2 && clen1 == clen2) {
            return BinaryAccessType.MATRIX_MATRIX;
        }
        if (clen1 > 1 && clen2 == 1) {
            return BinaryAccessType.MATRIX_COL_VECTOR;
        }
        if (rlen1 > 1 && clen1 > 1 && rlen2 == 1) {
            return BinaryAccessType.MATRIX_ROW_VECTOR;
        }
        if (clen1 == 1 && rlen2 == 1) {
            return BinaryAccessType.OUTER_VECTOR_VECTOR;
        }
        return BinaryAccessType.INVALID;
    }

    public static boolean isValidDimensionsBinary(MatrixBlock m1, MatrixBlock m2) {
        int rlen1 = m1.rlen;
        int clen1 = m1.clen;
        int rlen2 = m2.rlen;
        int clen2 = m2.clen;
        return rlen1 == rlen2 && clen1 == clen2 || rlen1 == rlen2 && clen1 > 1 && clen2 == 1 || clen1 == clen2 && rlen1 > 1 && rlen2 == 1 || clen1 == 1 && rlen2 == 1;
    }

    public static boolean isSparseSafeDivide(BinaryOperator op, MatrixBlock rhs) {
        return op.fn instanceof Divide && rhs.getNonZeros() == (long)rhs.getNumRows() * (long)rhs.getNumColumns();
    }

    private static void safeBinary(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        boolean skipEmpty;
        boolean bl = skipEmpty = op.fn instanceof Multiply || LibMatrixBincell.isSparseSafeDivide(op, m2);
        if (m1.isEmptyBlock(false) && m2.isEmptyBlock(false) || skipEmpty && (m1.isEmptyBlock(false) || m2.isEmptyBlock(false))) {
            return;
        }
        int rlen = m1.rlen;
        int clen = m1.clen;
        BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
        if (atype == BinaryAccessType.MATRIX_COL_VECTOR || atype == BinaryAccessType.MATRIX_ROW_VECTOR) {
            if (!(m1.sparse || m2.sparse || ret.sparse)) {
                LibMatrixBincell.safeBinaryMVDense(m1, m2, ret, op);
            } else if (m1.sparse) {
                LibMatrixBincell.safeBinaryMVSparse(m1, m2, ret, op);
            } else {
                LibMatrixBincell.safeBinaryMVGeneric(m1, m2, ret, op);
            }
        } else if (atype == BinaryAccessType.OUTER_VECTOR_VECTOR) {
            LibMatrixBincell.safeBinaryVVGeneric(m1, m2, ret, op);
        } else if (m1.sparse && m2.sparse) {
            if (ret.sparse) {
                ret.allocateSparseRowsBlock();
            }
            if (m1.sparseBlock != null && m2.sparseBlock != null) {
                SparseBlock lsblock = m1.sparseBlock;
                SparseBlock rsblock = m2.sparseBlock;
                if (ret.sparse && lsblock.isAligned(rsblock)) {
                    SparseBlock c = ret.sparseBlock;
                    for (int r = 0; r < rlen; ++r) {
                        if (lsblock.isEmpty(r)) continue;
                        int alen = lsblock.size(r);
                        int apos = lsblock.pos(r);
                        int[] aix = lsblock.indexes(r);
                        double[] avals = lsblock.values(r);
                        double[] bvals = rsblock.values(r);
                        c.allocate(r, alen);
                        for (int j = apos; j < apos + alen; ++j) {
                            double tmp = op.fn.execute(avals[j], bvals[j]);
                            c.append(r, aix[j], tmp);
                        }
                        ret.nonZeros += (long)c.size(r);
                    }
                } else {
                    for (int r = 0; r < rlen; ++r) {
                        if (!lsblock.isEmpty(r) && !rsblock.isEmpty(r)) {
                            LibMatrixBincell.mergeForSparseBinary(op, lsblock.values(r), lsblock.indexes(r), lsblock.pos(r), lsblock.size(r), rsblock.values(r), rsblock.indexes(r), rsblock.pos(r), rsblock.size(r), r, ret);
                            continue;
                        }
                        if (!rsblock.isEmpty(r)) {
                            LibMatrixBincell.appendRightForSparseBinary(op, rsblock.values(r), rsblock.indexes(r), rsblock.pos(r), rsblock.size(r), 0, r, ret);
                            continue;
                        }
                        if (lsblock.isEmpty(r)) continue;
                        LibMatrixBincell.appendLeftForSparseBinary(op, lsblock.values(r), lsblock.indexes(r), lsblock.pos(r), lsblock.size(r), 0, r, ret);
                    }
                }
            } else if (m2.sparseBlock != null) {
                SparseBlock rsblock = m2.sparseBlock;
                for (int r = 0; r < Math.min(rlen, rsblock.numRows()); ++r) {
                    if (rsblock.isEmpty(r)) continue;
                    LibMatrixBincell.appendRightForSparseBinary(op, rsblock.values(r), rsblock.indexes(r), rsblock.pos(r), rsblock.size(r), 0, r, ret);
                }
            } else {
                SparseBlock lsblock = m1.sparseBlock;
                for (int r = 0; r < rlen; ++r) {
                    if (lsblock.isEmpty(r)) continue;
                    LibMatrixBincell.appendLeftForSparseBinary(op, lsblock.values(r), lsblock.indexes(r), lsblock.pos(r), lsblock.size(r), 0, r, ret);
                }
            }
        } else if (!ret.sparse && (m1.sparse || m2.sparse) && (op.fn instanceof Plus || op.fn instanceof Minus || op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply || op.fn instanceof Multiply && !m2.sparse)) {
            int k;
            double[] avals;
            int[] aix;
            int alen;
            int apos;
            int ix;
            int i;
            SparseBlock a;
            ret.allocateDenseBlock();
            int m = ret.rlen;
            int n = ret.clen;
            double[] c = ret.denseBlock;
            if (m1.sparse) {
                Arrays.fill(ret.denseBlock, 0, ret.denseBlock.length, 0.0);
                if (m1.sparseBlock != null) {
                    a = m1.sparseBlock;
                    i = 0;
                    ix = 0;
                    while (i < m) {
                        if (!a.isEmpty(i)) {
                            apos = a.pos(i);
                            alen = a.size(i);
                            aix = a.indexes(i);
                            avals = a.values(i);
                            for (k = apos; k < apos + alen; ++k) {
                                c[ix + aix[k]] = avals[k];
                            }
                        }
                        ++i;
                        ix += n;
                    }
                }
            } else if (!m1.isEmptyBlock(false)) {
                System.arraycopy(m1.denseBlock, 0, c, 0, m * n);
            } else {
                Arrays.fill(ret.denseBlock, 0, m * n, 0.0);
            }
            if (m2.sparse) {
                if (m2.sparseBlock != null) {
                    a = m2.sparseBlock;
                    i = 0;
                    ix = 0;
                    while (i < m) {
                        if (!a.isEmpty(i)) {
                            apos = a.pos(i);
                            alen = a.size(i);
                            aix = a.indexes(i);
                            avals = a.values(i);
                            for (k = apos; k < apos + alen; ++k) {
                                c[ix + aix[k]] = op.fn.execute(c[ix + aix[k]], avals[k]);
                            }
                        }
                        ++i;
                        ix += n;
                    }
                }
            } else if (!m2.isEmptyBlock(false)) {
                for (int i2 = 0; i2 < m * n; ++i2) {
                    c[i2] = op.fn.execute(c[i2], m2.denseBlock[i2]);
                }
            } else if (op.fn instanceof Multiply) {
                Arrays.fill(ret.denseBlock, 0, m * n, 0.0);
            }
            ret.recomputeNonZeros();
        } else if (!(ret.sparse || m1.sparse || m2.sparse || m1.denseBlock == null || m2.denseBlock == null)) {
            ret.allocateDenseBlock();
            int m = ret.rlen;
            int n = ret.clen;
            double[] a = m1.denseBlock;
            double[] b = m2.denseBlock;
            double[] c = ret.denseBlock;
            ValueFunction fn = op.fn;
            int nnz = 0;
            for (int i = 0; i < m * n; ++i) {
                c[i] = fn.execute(a[i], b[i]);
                nnz += c[i] != 0.0 ? 1 : 0;
            }
            ret.nonZeros = nnz;
        } else if (skipEmpty && (m1.sparse || m2.sparse)) {
            SparseBlock a;
            SparseBlock sparseBlock = a = m1.sparse ? m1.sparseBlock : m2.sparseBlock;
            if (a == null) {
                return;
            }
            MatrixBlock b = m1.sparse ? m2 : m1;
            ret.allocateDenseOrSparseBlock();
            for (int i = 0; i < a.numRows(); ++i) {
                if (a.isEmpty(i)) continue;
                int apos = a.pos(i);
                int alen = a.size(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                if (ret.sparse && !b.sparse) {
                    ret.sparseBlock.allocate(i, alen);
                }
                for (int k = apos; k < apos + alen; ++k) {
                    double in2 = b.quickGetValue(i, aix[k]);
                    if (in2 == 0.0) continue;
                    double val = op.fn.execute(avals[k], in2);
                    ret.appendValue(i, aix[k], val);
                }
            }
        } else {
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double in1 = m1.quickGetValue(r, c);
                    double in2 = m2.quickGetValue(r, c);
                    if (in1 == 0.0 && in2 == 0.0) continue;
                    double val = op.fn.execute(in1, in2);
                    ret.appendValue(r, c, val);
                }
            }
        }
    }

    private static void safeBinaryMVDense(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        boolean isMultiply;
        boolean skipEmpty = isMultiply = op.fn instanceof Multiply;
        BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
        int rlen = m1.rlen;
        int clen = m1.clen;
        if (skipEmpty && (m1.isEmptyBlock(false) || m2.isEmptyBlock(false))) {
            return;
        }
        ret.allocateDenseBlock();
        double[] a = m1.denseBlock;
        double[] b = m2.denseBlock;
        double[] c = ret.denseBlock;
        int nnz = 0;
        if (atype == BinaryAccessType.MATRIX_COL_VECTOR) {
            int i = 0;
            int ix = 0;
            while (i < rlen) {
                double v2;
                double d = v2 = b == null ? 0.0 : b[i];
                if (!skipEmpty || v2 != 0.0) {
                    if (isMultiply && v2 == 1.0) {
                        System.arraycopy(a, ix, c, ix, clen);
                        nnz = (int)((long)nnz + m1.recomputeNonZeros(i, i, 0, clen - 1));
                    } else if (a != null) {
                        for (int j = 0; j < clen; ++j) {
                            c[ix + j] = op.fn.execute(a[ix + j], v2);
                            nnz += c[ix + j] != 0.0 ? 1 : 0;
                        }
                    } else {
                        double val = op.fn.execute(0.0, v2);
                        Arrays.fill(c, ix, ix + clen, val);
                        nnz += val != 0.0 ? clen : 0;
                    }
                }
                ++i;
                ix += clen;
            }
        } else if (atype == BinaryAccessType.MATRIX_ROW_VECTOR) {
            if (a == null && b == null) {
                double v = op.fn.execute(0L, 0L);
                Arrays.fill(c, 0, rlen * clen, v);
                nnz += v != 0.0 ? rlen * clen : 0;
            } else if (a == null) {
                for (int j = 0; j < clen; ++j) {
                    c[j] = op.fn.execute(0.0, b[j]);
                    nnz += c[j] != 0.0 ? rlen : 0;
                }
                int i = 1;
                int ix = clen;
                while (i < rlen) {
                    System.arraycopy(c, 0, c, ix, clen);
                    ++i;
                    ix += clen;
                }
            } else {
                int i = 0;
                int ix = 0;
                while (i < rlen) {
                    for (int j = 0; j < clen; ++j) {
                        c[ix + j] = op.fn.execute(a[ix + j], b != null ? b[j] : 0.0);
                        nnz += c[ix + j] != 0.0 ? 1 : 0;
                    }
                    ++i;
                    ix += clen;
                }
            }
        }
        ret.nonZeros = nnz;
    }

    private static void safeBinaryMVSparse(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        block14: {
            BinaryAccessType atype;
            SparseBlock a;
            int clen;
            int rlen;
            boolean skipEmpty;
            block13: {
                boolean isMultiply;
                skipEmpty = isMultiply = op.fn instanceof Multiply;
                rlen = m1.rlen;
                clen = m1.clen;
                a = m1.sparseBlock;
                atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
                if (skipEmpty && (m1.isEmptyBlock(false) || m2.isEmptyBlock(false))) {
                    return;
                }
                if (ret.sparse) {
                    ret.allocateSparseRowsBlock();
                }
                if (atype != BinaryAccessType.MATRIX_COL_VECTOR) break block13;
                for (int i = 0; i < rlen; ++i) {
                    double v2 = m2.quickGetValue(i, 0);
                    if (skipEmpty && (a == null || a.isEmpty(i) || v2 == 0.0) || (a == null || a.isEmpty(i)) && v2 == 0.0) continue;
                    if (isMultiply && v2 == 1.0) {
                        if (a == null || a.isEmpty(i)) continue;
                        ret.appendRow(i, a.get(i));
                        continue;
                    }
                    int lastIx = -1;
                    if (a != null && !a.isEmpty(i)) {
                        int apos = a.pos(i);
                        int alen = a.size(i);
                        int[] aix = a.indexes(i);
                        double[] avals = a.values(i);
                        for (int j = apos; j < apos + alen; ++j) {
                            for (int k = lastIx + 1; k < aix[j]; ++k) {
                                double v = op.fn.execute(0.0, v2);
                                ret.appendValue(i, k, v);
                            }
                            double v = op.fn.execute(avals[j], v2);
                            ret.appendValue(i, aix[j], v);
                            lastIx = aix[j];
                        }
                    }
                    for (int k = lastIx + 1; k < clen; ++k) {
                        double v = op.fn.execute(0.0, v2);
                        ret.appendValue(i, k, v);
                    }
                }
                break block14;
            }
            if (atype != BinaryAccessType.MATRIX_ROW_VECTOR) break block14;
            for (int i = 0; i < rlen; ++i) {
                if (skipEmpty && (a == null || a.isEmpty(i))) continue;
                int lastIx = -1;
                if (a != null && !a.isEmpty(i)) {
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        for (int k = lastIx + 1; !skipEmpty && k < aix[j]; ++k) {
                            double v2 = m2.quickGetValue(0, k);
                            double v = op.fn.execute(0.0, v2);
                            ret.appendValue(i, k, v);
                        }
                        double v2 = m2.quickGetValue(0, aix[j]);
                        double v = op.fn.execute(avals[j], v2);
                        ret.appendValue(i, aix[j], v);
                        lastIx = aix[j];
                    }
                }
                for (int k = lastIx + 1; !skipEmpty && k < clen; ++k) {
                    double v2 = m2.quickGetValue(0, k);
                    double v = op.fn.execute(0.0, v2);
                    ret.appendValue(i, k, v);
                }
            }
        }
    }

    private static void safeBinaryMVGeneric(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        block11: {
            int clen;
            int rlen;
            block12: {
                BinaryAccessType atype;
                boolean isMultiply;
                block10: {
                    boolean skipEmpty = isMultiply = op.fn instanceof Multiply;
                    rlen = m1.rlen;
                    clen = m1.clen;
                    atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
                    if (skipEmpty && (m1.isEmptyBlock(false) || m2.isEmptyBlock(false))) {
                        return;
                    }
                    if (ret.sparse) {
                        ret.allocateSparseRowsBlock();
                    }
                    if (atype != BinaryAccessType.MATRIX_COL_VECTOR) break block10;
                    for (int i = 0; i < rlen; ++i) {
                        double v1;
                        int j;
                        double v2 = m2.quickGetValue(i, 0);
                        if (skipEmpty && v2 == 0.0) continue;
                        if (isMultiply && v2 == 1.0) {
                            for (j = 0; j < clen; ++j) {
                                v1 = m1.quickGetValue(i, j);
                                ret.appendValue(i, j, v1);
                            }
                            continue;
                        }
                        for (j = 0; j < clen; ++j) {
                            v1 = m1.quickGetValue(i, j);
                            double v = op.fn.execute(v1, v2);
                            ret.appendValue(i, j, v);
                        }
                    }
                    break block11;
                }
                if (atype != BinaryAccessType.MATRIX_ROW_VECTOR) break block11;
                if (!m2.sparse || !isMultiply) break block12;
                SparseBlock b = m2.sparseBlock;
                if (b.isEmpty(0)) break block11;
                int blen = b.size(0);
                int[] bix = b.indexes(0);
                double[] bvals = b.values(0);
                for (int i = 0; i < rlen; ++i) {
                    for (int j = 0; j < blen; ++j) {
                        double v1 = m1.quickGetValue(i, bix[j]);
                        double v = op.fn.execute(v1, bvals[j]);
                        ret.appendValue(i, bix[j], v);
                    }
                }
                break block11;
            }
            for (int i = 0; i < rlen; ++i) {
                for (int j = 0; j < clen; ++j) {
                    double v1 = m1.quickGetValue(i, j);
                    double v2 = m2.quickGetValue(0, j);
                    double v = op.fn.execute(v1, v2);
                    ret.appendValue(i, j, v);
                }
            }
        }
    }

    private static void safeBinaryVVGeneric(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        int rlen = m1.rlen;
        int clen = m2.clen;
        if (ret.sparse) {
            ret.allocateSparseRowsBlock();
        }
        if (LibMatrixOuterAgg.isCompareOperator(op) && SortUtils.isSorted(0, m2.getNumColumns(), DataConverter.convertToDoubleVector(m2))) {
            LibMatrixBincell.performBinOuterOperation(m1, m2, ret, op);
        } else {
            for (int r = 0; r < rlen; ++r) {
                double v1 = m1.quickGetValue(r, 0);
                for (int c = 0; c < clen; ++c) {
                    double v2 = m2.quickGetValue(0, c);
                    double v = op.fn.execute(v1, v2);
                    ret.appendValue(r, c, v);
                }
            }
        }
    }

    private static void performBinOuterOperation(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp) throws DMLRuntimeException {
        int rlen = mbLeft.rlen;
        double[] bv = DataConverter.convertToDoubleVector(mbRight);
        if (!mbOut.isAllocated()) {
            mbOut.allocateDenseBlock();
        }
        long lNNZ = 0L;
        for (int r = 0; r < rlen; ++r) {
            int ixPos1;
            double value = mbLeft.quickGetValue(r, 0);
            int ixPos2 = ixPos1 = Arrays.binarySearch(bv, value);
            if (ixPos1 >= 0) {
                if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThanEquals || bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                    while (ixPos1 < bv.length && value == bv[ixPos1]) {
                        ++ixPos1;
                    }
                }
                if (bOp.fn instanceof GreaterThan || bOp.fn instanceof LessThanEquals || bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                    while (ixPos2 > 0 && value == bv[ixPos2 - 1]) {
                        --ixPos2;
                    }
                }
            } else {
                ixPos2 = ixPos1 = Math.abs(ixPos1) - 1;
            }
            int iStartPos = 0;
            int iEndPos = bv.length;
            if (bOp.fn instanceof LessThan) {
                iStartPos = ixPos1;
            } else if (bOp.fn instanceof LessThanEquals) {
                iStartPos = ixPos2;
            } else if (bOp.fn instanceof GreaterThan) {
                iEndPos = ixPos2;
            } else if (bOp.fn instanceof GreaterThanEquals) {
                iEndPos = ixPos1;
            } else if (bOp.fn instanceof Equals || bOp.fn instanceof NotEquals) {
                iStartPos = ixPos2;
                iEndPos = ixPos1;
            }
            if (iStartPos >= iEndPos && !(bOp.fn instanceof NotEquals)) continue;
            int iOffSet = r * mbRight.getNumColumns();
            if (bOp.fn instanceof LessThan || bOp.fn instanceof GreaterThanEquals || bOp.fn instanceof GreaterThan || bOp.fn instanceof LessThanEquals || bOp.fn instanceof Equals) {
                Arrays.fill(mbOut.getDenseBlock(), iOffSet + iStartPos, iOffSet + iEndPos, 1.0);
                lNNZ += (long)(iEndPos - iStartPos);
                continue;
            }
            if (!(bOp.fn instanceof NotEquals)) continue;
            Arrays.fill(mbOut.getDenseBlock(), iOffSet, iOffSet + iStartPos, 1.0);
            Arrays.fill(mbOut.getDenseBlock(), iOffSet + iEndPos, iOffSet + bv.length, 1.0);
            lNNZ += (long)(iStartPos + (bv.length - iEndPos));
        }
        mbOut.setNonZeros(lNNZ);
        mbOut.examSparsity();
    }

    private static void unsafeBinary(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, BinaryOperator op) throws DMLRuntimeException {
        int rlen = m1.rlen;
        int clen = m1.clen;
        BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
        if (atype == BinaryAccessType.MATRIX_COL_VECTOR) {
            for (int r = 0; r < rlen; ++r) {
                double v2 = m2.quickGetValue(r, 0);
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1.quickGetValue(r, c);
                    double v = op.fn.execute(v1, v2);
                    ret.appendValue(r, c, v);
                }
            }
        } else if (atype == BinaryAccessType.MATRIX_ROW_VECTOR) {
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1.quickGetValue(r, c);
                    double v2 = m2.quickGetValue(0, c);
                    double v = op.fn.execute(v1, v2);
                    ret.appendValue(r, c, v);
                }
            }
        } else if (atype == BinaryAccessType.OUTER_VECTOR_VECTOR) {
            int clen2 = m2.clen;
            if (LibMatrixOuterAgg.isCompareOperator(op) && SortUtils.isSorted(0, m2.getNumColumns(), DataConverter.convertToDoubleVector(m2))) {
                LibMatrixBincell.performBinOuterOperation(m1, m2, ret, op);
            } else {
                for (int r = 0; r < rlen; ++r) {
                    double v1 = m1.quickGetValue(r, 0);
                    for (int c = 0; c < clen2; ++c) {
                        double v2 = m2.quickGetValue(0, c);
                        double v = op.fn.execute(v1, v2);
                        ret.appendValue(r, c, v);
                    }
                }
            }
        } else if (!(m1.clen != 1 || m1.sparse || m1.isEmptyBlock(false) || m2.sparse || m2.isEmptyBlock(false))) {
            ret.allocateDenseBlock();
            double[] a = m1.denseBlock;
            double[] b = m2.denseBlock;
            double[] c = ret.denseBlock;
            for (int i = 0; i < rlen; ++i) {
                c[i] = op.fn.execute(a[i], b[i]);
                if (c[i] == 0.0) continue;
                ++ret.nonZeros;
            }
        } else {
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1.quickGetValue(r, c);
                    double v2 = m2.quickGetValue(r, c);
                    double v = op.fn.execute(v1, v2);
                    ret.appendValue(r, c, v);
                }
            }
        }
    }

    private static void safeBinaryScalar(MatrixBlock m1, MatrixBlock ret, ScalarOperator op) throws DMLRuntimeException {
        boolean copyOnes;
        if (m1.isEmptyBlock(false)) {
            return;
        }
        if (m1.sparse != ret.sparse) {
            throw new DMLRuntimeException("Unsupported safe binary scalar operations over different input/output representation: " + m1.sparse + " " + ret.sparse);
        }
        boolean bl = copyOnes = op.fn instanceof NotEquals && op.getConstant() == 0.0;
        if (m1.sparse) {
            ret.allocateSparseRowsBlock();
            SparseBlock a = m1.sparseBlock;
            SparseBlock c = ret.sparseBlock;
            int rlen = Math.min(m1.rlen, a.numRows());
            long nnz = 0L;
            for (int r = 0; r < rlen; ++r) {
                if (a.isEmpty(r)) continue;
                int apos = a.pos(r);
                int alen = a.size(r);
                int[] aix = a.indexes(r);
                double[] avals = a.values(r);
                if (copyOnes) {
                    SparseRow crow = new SparseRow(alen);
                    crow.setSize(alen);
                    System.arraycopy(aix, apos, crow.indexes(), 0, alen);
                    Arrays.fill(crow.values(), 0, alen, 1.0);
                    c.set(r, crow, false);
                    nnz += (long)alen;
                    continue;
                }
                if (op.fn instanceof Multiply || op.fn instanceof Multiply2 || op.fn instanceof Power2) {
                    c.allocate(r, alen);
                }
                for (int j = apos; j < apos + alen; ++j) {
                    double val = op.executeScalar(avals[j]);
                    c.append(r, aix[j], val);
                    nnz += val != 0.0 ? 1L : 0L;
                }
            }
            ret.nonZeros = nnz;
        } else {
            LibMatrixBincell.denseBinaryScalar(m1, ret, op);
        }
    }

    private static void unsafeBinaryScalar(MatrixBlock m1, MatrixBlock ret, ScalarOperator op) throws DMLRuntimeException {
        if (m1.isEmptyBlock(false)) {
            double val = op.executeScalar(0.0);
            if (val != 0.0) {
                ret.reset(ret.rlen, ret.clen, val);
            }
            return;
        }
        if (ret.sparse) {
            throw new DMLRuntimeException("Unsupported unsafe binary scalar operations over sparse output representation.");
        }
        if (m1.sparse) {
            ret.allocateDenseBlock();
            SparseBlock a = m1.sparseBlock;
            double[] c = ret.denseBlock;
            int m = m1.rlen;
            int n = m1.clen;
            double cval0 = op.executeScalar(0.0);
            Arrays.fill(c, cval0);
            int nnz = m * n;
            int i = 0;
            int cix = 0;
            while (i < m) {
                if (!a.isEmpty(i)) {
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        double val;
                        c[cix + aix[j]] = val = op.executeScalar(avals[j]);
                        nnz -= val == 0.0 ? 1 : 0;
                    }
                }
                ++i;
                cix += n;
            }
            ret.nonZeros = nnz;
        } else {
            LibMatrixBincell.denseBinaryScalar(m1, ret, op);
        }
    }

    private static void denseBinaryScalar(MatrixBlock m1, MatrixBlock ret, ScalarOperator op) throws DMLRuntimeException {
        ret.allocateDenseBlock(true);
        double[] a = m1.denseBlock;
        double[] c = ret.denseBlock;
        int limit = m1.rlen * m1.clen;
        int nnz = 0;
        for (int i = 0; i < limit; ++i) {
            c[i] = op.executeScalar(a[i]);
            nnz += c[i] != 0.0 ? 1 : 0;
        }
        ret.nonZeros = nnz;
    }

    private static void safeBinaryInPlace(MatrixBlock m1ret, MatrixBlock m2, BinaryOperator op) throws DMLRuntimeException {
        block17: {
            int clen;
            int rlen;
            block15: {
                SparseBlock c;
                block18: {
                    SparseBlock b;
                    block16: {
                        if (m1ret.isEmptyBlock(false) && m2.isEmptyBlock(false)) {
                            return;
                        }
                        if (op.fn instanceof Plus && m1ret.isEmptyBlock(false)) {
                            m1ret.copy(m2);
                            return;
                        }
                        rlen = m1ret.rlen;
                        clen = m1ret.clen;
                        if (!m1ret.sparse || !m2.sparse) break block15;
                        if (m1ret.sparseBlock != null) {
                            m1ret.allocateSparseRowsBlock(false);
                        }
                        if (m2.sparseBlock != null) {
                            m2.allocateSparseRowsBlock(false);
                        }
                        c = m1ret.sparseBlock;
                        b = m2.sparseBlock;
                        if (c == null || b == null) break block16;
                        for (int r = 0; r < rlen; ++r) {
                            if (c.isEmpty(r) && b.isEmpty(r)) continue;
                            if (b.isEmpty(r)) {
                                int apos = c.pos(r);
                                int alen = c.size(r);
                                double[] values = c.values(r);
                                for (int i = apos; i < apos + alen; ++i) {
                                    values[i] = op.fn.execute(values[i], 0.0);
                                }
                                continue;
                            }
                            int estimateSize = 0;
                            if (!c.isEmpty(r)) {
                                estimateSize += c.size(r);
                            }
                            if (!b.isEmpty(r)) {
                                estimateSize += b.size(r);
                            }
                            estimateSize = Math.min(clen, estimateSize);
                            SparseRow thisRow = c.get(r);
                            c.set(r, new SparseRow(estimateSize, clen), false);
                            if (thisRow != null) {
                                m1ret.nonZeros -= (long)thisRow.size();
                                LibMatrixBincell.mergeForSparseBinary(op, thisRow.values(), thisRow.indexes(), 0, thisRow.size(), b.values(r), b.indexes(r), b.pos(r), b.size(r), r, m1ret);
                                continue;
                            }
                            LibMatrixBincell.appendRightForSparseBinary(op, b.values(r), b.indexes(r), b.pos(r), b.size(r), 0, r, m1ret);
                        }
                        break block17;
                    }
                    if (m1ret.sparseBlock != null) break block18;
                    m1ret.sparseBlock = SparseBlockFactory.createSparseBlock(rlen);
                    for (int r = 0; r < rlen; ++r) {
                        if (b.isEmpty(r)) continue;
                        SparseRow tmp = new SparseRow(b.size(r), clen);
                        LibMatrixBincell.appendRightForSparseBinary(op, b.values(r), b.indexes(r), b.pos(r), b.size(r), 0, r, m1ret);
                        m1ret.sparseBlock.set(r, tmp, false);
                    }
                    break block17;
                }
                if (op.fn instanceof Plus || op.fn instanceof Minus || op.fn instanceof Or) break block17;
                for (int r = 0; r < rlen; ++r) {
                    if (c.isEmpty(r)) continue;
                    SparseRow tmp = c.get(r);
                    int alen = tmp.size();
                    double[] avals = tmp.values();
                    for (int j = 0; j < alen; ++j) {
                        avals[j] = op.fn.execute(avals[j], 0.0);
                    }
                    tmp.compact();
                    c.set(r, tmp, false);
                }
                break block17;
            }
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double thisvalue = m1ret.quickGetValue(r, c);
                    double thatvalue = m2.quickGetValue(r, c);
                    double resultvalue = op.fn.execute(thisvalue, thatvalue);
                    m1ret.quickSetValue(r, c, resultvalue);
                }
            }
        }
    }

    private static void unsafeBinaryInPlace(MatrixBlock m1ret, MatrixBlock m2, BinaryOperator op) throws DMLRuntimeException {
        int rlen = m1ret.rlen;
        int clen = m1ret.clen;
        BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1ret, m2);
        if (atype == BinaryAccessType.MATRIX_COL_VECTOR) {
            for (int r = 0; r < rlen; ++r) {
                double v2 = m2.quickGetValue(r, 0);
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1ret.quickGetValue(r, c);
                    double v = op.fn.execute(v1, v2);
                    m1ret.quickSetValue(r, c, v);
                }
            }
        } else if (atype == BinaryAccessType.MATRIX_ROW_VECTOR) {
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1ret.quickGetValue(r, c);
                    double v2 = m2.quickGetValue(0, c);
                    double v = op.fn.execute(v1, v2);
                    m1ret.quickSetValue(r, c, v);
                }
            }
        } else {
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    double v1 = m1ret.quickGetValue(r, c);
                    double v2 = m2.quickGetValue(r, c);
                    double v = op.fn.execute(v1, v2);
                    m1ret.quickSetValue(r, c, v);
                }
            }
        }
    }

    private static void mergeForSparseBinary(BinaryOperator op, double[] values1, int[] cols1, int pos1, int size1, double[] values2, int[] cols2, int pos2, int size2, int resultRow, MatrixBlock result) throws DMLRuntimeException {
        int p1 = 0;
        int p2 = 0;
        while (p1 < size1 && p2 < size2) {
            int column;
            double value = 0.0;
            if (cols1[pos1 + p1] < cols2[pos2 + p2]) {
                value = op.fn.execute(values1[pos1 + p1], 0.0);
                column = cols1[pos1 + p1];
                ++p1;
            } else if (cols1[pos1 + p1] == cols2[pos2 + p2]) {
                value = op.fn.execute(values1[pos1 + p1], values2[pos2 + p2]);
                column = cols1[pos1 + p1];
                ++p1;
                ++p2;
            } else {
                value = op.fn.execute(0.0, values2[pos2 + p2]);
                column = cols2[pos2 + p2];
                ++p2;
            }
            result.appendValue(resultRow, column, value);
        }
        LibMatrixBincell.appendLeftForSparseBinary(op, values1, cols1, pos1, size1, p1, resultRow, result);
        LibMatrixBincell.appendRightForSparseBinary(op, values2, cols2, pos2, size2, p2, resultRow, result);
    }

    private static void appendLeftForSparseBinary(BinaryOperator op, double[] values1, int[] cols1, int pos1, int size1, int pos, int resultRow, MatrixBlock result) throws DMLRuntimeException {
        for (int j = pos1 + pos; j < pos1 + size1; ++j) {
            double v = op.fn.execute(values1[j], 0.0);
            result.appendValue(resultRow, cols1[j], v);
        }
    }

    private static void appendRightForSparseBinary(BinaryOperator op, double[] values2, int[] cols2, int pos2, int size2, int pos, int resultRow, MatrixBlock result) throws DMLRuntimeException {
        for (int j = pos2 + pos; j < pos2 + size2; ++j) {
            double v = op.fn.execute(0.0, values2[j]);
            result.appendValue(resultRow, cols2[j], v);
        }
    }

    public static enum BinaryAccessType {
        MATRIX_MATRIX,
        MATRIX_COL_VECTOR,
        MATRIX_ROW_VECTOR,
        OUTER_VECTOR_VECTOR,
        INVALID;

    }
}

