/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.MapReduceTool;

public class WriterTextCell
extends MatrixWriter {
    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int brlen, int bclen, long nnz) throws IOException, DMLRuntimeException {
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Matrix dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = FileSystem.get((Configuration)job);
        Path path = new Path(fname);
        MapReduceTool.deleteFileIfExistOnHDFS(fname);
        this.writeTextCellMatrixToHDFS(path, job, fs, src, rlen, clen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        Path path = new Path(fname);
        FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
        FSDataOutputStream writer = null;
        try {
            writer = fs.create(path);
            writer.writeBytes("1 1 0");
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeTextCellMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen) throws IOException {
        this.writeTextCellMatrixToFile(path, job, fs, src, 0, (int)rlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeTextCellMatrixToFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int clen = src.getNumColumns();
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        try {
            StringBuilder sb = new StringBuilder();
            if (sparse) {
                Iterator<IJV> iter = src.getSparseBlockIterator(rl, ru);
                while (iter.hasNext()) {
                    IJV cell = iter.next();
                    sb.append(cell.getI() + 1);
                    sb.append(' ');
                    sb.append(cell.getJ() + 1);
                    sb.append(' ');
                    sb.append(cell.getV());
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            } else {
                for (int i = rl; i < ru; ++i) {
                    String rowIndex = Integer.toString(i + 1);
                    for (int j = 0; j < clen; ++j) {
                        double lvalue = src.getValueDenseUnsafe(i, j);
                        if (lvalue == 0.0) continue;
                        sb.append(rowIndex);
                        sb.append(' ');
                        sb.append(j + 1);
                        sb.append(' ');
                        sb.append(lvalue);
                        sb.append('\n');
                        br.write(sb.toString());
                        sb.setLength(0);
                    }
                }
            }
            if (src.isEmptyBlock(false) && rl == 0) {
                br.write("1 1 0\n");
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

