/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ReaderTextCSV
extends MatrixReader {
    private CSVFileFormatProperties _props = null;

    public ReaderTextCSV(CSVFileFormatProperties props) {
        this._props = props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen > 0L && clen > 0L) {
            ret = ReaderTextCSV.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = FileSystem.get((Configuration)job);
        Path path = new Path(fname);
        ReaderTextCSV.checkValidInputFile(fs, path);
        ret = this.readCSVMatrixFromHDFS(path, job, fs, ret, rlen, clen, brlen, bclen, this._props.hasHeader(), this._props.getDelim(), this._props.isFill(), this._props.getFillValue());
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderTextCSV.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        long lnnz = this.readCSVMatrixFromInputStream(is, "external inputstream", ret, new MutableInt(0), rlen, clen, brlen, bclen, this._props.hasHeader(), this._props.getDelim(), this._props.isFill(), this._props.getFillValue(), true);
        ret.setNonZeros(lnnz);
        ret.examSparsity();
        return ret;
    }

    private MatrixBlock readCSVMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean hasHeader, String delim, boolean fill, double fillValue) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        if (fs.isDirectory(path)) {
            for (FileStatus stat : fs.listStatus(path, CSVReblockMR.hiddenFileFilter)) {
                files.add(stat.getPath());
            }
            Collections.sort(files);
        } else {
            files.add(path);
        }
        if (dest == null) {
            dest = this.computeCSVSize(files, job, fs, hasHeader, delim, fill, fillValue);
            clen = dest.getNumColumns();
        }
        long lnnz = 0L;
        MutableInt row = new MutableInt(0);
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            lnnz += this.readCSVMatrixFromInputStream((InputStream)fs.open(files.get(fileNo)), path.toString(), dest, row, rlen, clen, brlen, bclen, hasHeader, delim, fill, fillValue, fileNo == 0);
        }
        dest.setNonZeros(lnnz);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readCSVMatrixFromInputStream(InputStream is, String srcInfo, MatrixBlock dest, MutableInt rowPos, long rlen, long clen, int brlen, int bclen, boolean hasHeader, String delim, boolean fill, double fillValue, boolean first) throws IOException {
        boolean sparse = dest.isInSparseFormat();
        String value = null;
        int row = rowPos.intValue();
        double cellValue = 0.0;
        long lnnz = 0L;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        if (first && hasHeader) {
            br.readLine();
        }
        boolean emptyValuesFound = false;
        try {
            if (sparse) {
                while ((value = br.readLine()) != null) {
                    String cellStr = value.toString().trim();
                    emptyValuesFound = false;
                    String[] parts = IOUtilFunctions.split(cellStr, delim);
                    int col = 0;
                    for (String part : parts) {
                        if ((part = part.trim()).isEmpty()) {
                            emptyValuesFound = true;
                            cellValue = fillValue;
                        } else {
                            cellValue = UtilFunctions.parseToDouble(part);
                        }
                        if (cellValue != 0.0) {
                            dest.appendValue(row, col, cellValue);
                            ++lnnz;
                        }
                        ++col;
                    }
                    IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, fill, emptyValuesFound);
                    IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(srcInfo, cellStr, parts, clen);
                    ++row;
                }
            } else {
                while ((value = br.readLine()) != null) {
                    String cellStr = value.toString().trim();
                    emptyValuesFound = false;
                    String[] parts = IOUtilFunctions.split(cellStr, delim);
                    int col = 0;
                    for (String part : parts) {
                        if ((part = part.trim()).isEmpty()) {
                            emptyValuesFound = true;
                            cellValue = fillValue;
                        } else {
                            cellValue = UtilFunctions.parseToDouble(part);
                        }
                        if (cellValue != 0.0) {
                            dest.setValueDenseUnsafe(row, col, cellValue);
                            ++lnnz;
                        }
                        ++col;
                    }
                    IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, fill, emptyValuesFound);
                    IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(srcInfo, cellStr, parts, clen);
                    ++row;
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
        rowPos.setValue(row);
        return lnnz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixBlock computeCSVSize(List<Path> files, JobConf job, FileSystem fs, boolean hasHeader, String delim, boolean fill, double fillValue) throws IOException {
        int nrow = -1;
        int ncol = -1;
        String value = null;
        String cellStr = null;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(files.get(fileNo))));
            try {
                if (fileNo == 0) {
                    if (hasHeader) {
                        br.readLine();
                    }
                    if ((value = br.readLine()) != null) {
                        cellStr = value.toString().trim();
                        ncol = StringUtils.countMatches((String)cellStr, (String)delim) + 1;
                        nrow = 1;
                    }
                }
                while ((value = br.readLine()) != null) {
                    ++nrow;
                }
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
        }
        return new MatrixBlock(nrow, ncol, true);
    }
}

