/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;

public class ReaderBinaryCell
extends MatrixReader {
    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderBinaryCell.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = FileSystem.get((Configuration)job);
        Path path = new Path(fname);
        ReaderBinaryCell.checkValidInputFile(fs, path);
        this.readBinaryCellMatrixFromHDFS(path, job, fs, ret, rlen, clen, brlen, bclen);
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        throw new DMLRuntimeException("Not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBinaryCellMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int brlen, int bclen) throws IOException {
        boolean sparse = dest.isInSparseFormat();
        MatrixIndexes key = new MatrixIndexes();
        MatrixCell value = new MatrixCell();
        int row = -1;
        int col = -1;
        try {
            for (Path lpath : ReaderBinaryCell.getSequenceFilePaths(fs, path)) {
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
                try {
                    double lvalue;
                    if (sparse) {
                        while (reader.next((Writable)key, (Writable)value)) {
                            row = (int)key.getRowIndex() - 1;
                            col = (int)key.getColumnIndex() - 1;
                            lvalue = value.getValue();
                            dest.appendValue(row, col, lvalue);
                        }
                        continue;
                    }
                    while (reader.next((Writable)key, (Writable)value)) {
                        row = (int)key.getRowIndex() - 1;
                        col = (int)key.getColumnIndex() - 1;
                        lvalue = value.getValue();
                        dest.appendValue(row, col, lvalue);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently((Closeable)reader);
                }
            }
            if (sparse) {
                dest.sortSparseRows();
            }
        }
        catch (Exception ex) {
            if (row < 0 || (long)(row + 1) > rlen || col < 0 || (long)(col + 1) > clen) {
                throw new IOException("Matrix cell [" + (row + 1) + "," + (col + 1) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            throw new IOException("Unable to read matrix in binary cell format.", ex);
        }
    }
}

