/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FrameWriter;
import org.apache.sysml.runtime.io.FrameWriterBinaryBlock;
import org.apache.sysml.runtime.io.FrameWriterBinaryBlockParallel;
import org.apache.sysml.runtime.io.FrameWriterTextCSV;
import org.apache.sysml.runtime.io.FrameWriterTextCSVParallel;
import org.apache.sysml.runtime.io.FrameWriterTextCell;
import org.apache.sysml.runtime.io.FrameWriterTextCellParallel;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.OutputInfo;

public class FrameWriterFactory {
    public static FrameWriter createFrameWriter(OutputInfo oinfo) throws DMLRuntimeException {
        return FrameWriterFactory.createFrameWriter(oinfo, null);
    }

    public static FrameWriter createFrameWriter(OutputInfo oinfo, FileFormatProperties props) throws DMLRuntimeException {
        FrameWriter writer = null;
        if (oinfo == OutputInfo.TextCellOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new FrameWriterTextCellParallel() : new FrameWriterTextCell();
        } else if (oinfo == OutputInfo.CSVOutputInfo) {
            if (props != null && !(props instanceof CSVFileFormatProperties)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new FrameWriterTextCSVParallel((CSVFileFormatProperties)props) : new FrameWriterTextCSV((CSVFileFormatProperties)props);
        } else if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS) ? new FrameWriterBinaryBlockParallel() : new FrameWriterBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create frame writer for unknown output info: " + OutputInfo.outputInfoToString(oinfo));
        }
        return writer;
    }
}

