/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class GroupedAggregateInstruction
extends UnaryMRInstructionBase {
    private boolean _weights = false;
    private int _ngroups = -1;
    private long _bclen = -1L;

    public GroupedAggregateInstruction(Operator op, byte in, byte out, boolean weights, int ngroups, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.GroupedAggregate;
        this.instString = istr;
        this._weights = weights;
        this._ngroups = ngroups;
    }

    public boolean hasWeights() {
        return this._weights;
    }

    public int getNGroups() {
        return this._ngroups;
    }

    public void setBclen(long bclen) {
        this._bclen = bclen;
    }

    public long getBclen() {
        return this._bclen;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        throw new DMLRuntimeException("GroupedAggregateInstruction.processInstruction() should not be called!");
    }

    public static GroupedAggregateInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionParts(str);
        if (parts.length < 3) {
            throw new DMLRuntimeException("the number of fields of instruction " + str + " is less than 2!");
        }
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[parts.length - 3]);
        boolean weights = Boolean.parseBoolean(parts[parts.length - 2]);
        int ngroups = Integer.parseInt(parts[parts.length - 1]);
        if (!opcode.equalsIgnoreCase("groupedagg")) {
            throw new DMLRuntimeException("Invalid opcode in GroupedAggregateInstruction: " + opcode);
        }
        Operator optr = GroupedAggregateInstruction.parseGroupedAggOperator(parts[2], parts[3]);
        return new GroupedAggregateInstruction(optr, in, out, weights, ngroups, str);
    }

    public static Operator parseGroupedAggOperator(String fn, String other) throws DMLRuntimeException {
        CMOperator.AggregateOperationTypes op = CMOperator.AggregateOperationTypes.INVALID;
        op = fn.equalsIgnoreCase("centralmoment") ? CMOperator.getAggOpType(fn, other) : CMOperator.getAggOpType(fn, null);
        switch (op) {
            case SUM: {
                return new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.LASTCOLUMN);
            }
            case COUNT: 
            case MEAN: 
            case VARIANCE: 
            case CM2: 
            case CM3: 
            case CM4: {
                return new CMOperator(CM.getCMFnObject(op), op);
            }
        }
        throw new DMLRuntimeException("Invalid Aggregate Operation in GroupedAggregateInstruction: " + (Object)((Object)op));
    }
}

