/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CumulativeAggregateInstruction
extends AggregateUnaryInstruction {
    private MatrixCharacteristics _mcIn = null;

    public CumulativeAggregateInstruction(Operator op, byte in, byte out, String istr) {
        super(op, in, out, true, istr);
    }

    public void setMatrixCharacteristics(MatrixCharacteristics mcIn) {
        this._mcIn = mcIn;
    }

    public static CumulativeAggregateInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        AggregateUnaryOperator aggun = InstructionUtils.parseCumulativeAggregateUnaryOperator(opcode);
        return new CumulativeAggregateInstruction(aggun, in, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList == null) {
            return;
        }
        for (IndexedMatrixValue in1 : blkList) {
            if (in1 == null) continue;
            MatrixIndexes inix = in1.getIndexes();
            IndexedMatrixValue out = cachedValues.holdPlace(this.output, valueClass);
            OperationsOnMatrixValues.performAggregateUnary(inix, in1.getValue(), out.getIndexes(), out.getValue(), (AggregateUnaryOperator)this.optr, blockRowFactor, blockColFactor);
            if (((AggregateUnaryOperator)this.optr).aggOp.correctionExists) {
                ((MatrixBlock)out.getValue()).dropLastRowsOrColums(((AggregateUnaryOperator)this.optr).aggOp.correctionLocation);
            }
            long rlenOut = (long)Math.ceil((double)this._mcIn.getRows() / (double)blockRowFactor);
            long rixOut = (long)Math.ceil((double)inix.getRowIndex() / (double)blockRowFactor);
            int rlenBlk = (int)Math.min(rlenOut - (rixOut - 1L) * (long)blockRowFactor, (long)blockRowFactor);
            int clenBlk = out.getValue().getNumColumns();
            int posBlk = (int)((inix.getRowIndex() - 1L) % (long)blockRowFactor);
            MatrixBlock outBlk = new MatrixBlock(rlenBlk, clenBlk, false);
            outBlk.copy(posBlk, posBlk, 0, clenBlk - 1, (MatrixBlock)out.getValue(), true);
            MatrixIndexes outIx = out.getIndexes();
            outIx.setIndexes(rixOut, outIx.getColumnIndex());
            out.set(outIx, outBlk);
        }
    }
}

