/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu.context;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysml.runtime.instructions.gpu.context.JCudaContext;
import org.apache.sysml.runtime.instructions.gpu.context.JCudaObject;

public abstract class GPUContext {
    protected static GPUContext currContext;
    public static volatile Boolean isGPUContextCreated;

    protected GPUContext() {
    }

    public abstract long getAvailableMemory();

    public abstract void ensureComputeCapability() throws DMLRuntimeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPUContext getGPUContext() throws DMLRuntimeException {
        if (currContext == null && DMLScript.USE_ACCELERATOR) {
            Boolean bl = isGPUContextCreated;
            synchronized (bl) {
                currContext = new JCudaContext();
                currContext.ensureComputeCapability();
                OptimizerUtils.GPU_MEMORY_BUDGET = currContext.getAvailableMemory();
                isGPUContextCreated = true;
            }
        }
        return currContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPUObject createGPUObject(MatrixObject mo) {
        if (DMLScript.USE_ACCELERATOR) {
            Boolean bl = isGPUContextCreated;
            synchronized (bl) {
                if (currContext == null) {
                    throw new RuntimeException("GPUContext is not created");
                }
                if (currContext instanceof JCudaContext) {
                    return new JCudaObject(mo);
                }
            }
        }
        throw new RuntimeException("Cannot create createGPUObject when USE_ACCELERATOR is off");
    }

    public abstract void destroy() throws DMLRuntimeException;

    static {
        isGPUContextCreated = false;
    }
}

