/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cpfile;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.MapReduceTool;

public final class MatrixIndexingCPFileInstruction
extends IndexingCPInstruction {
    public MatrixIndexingCPFileInstruction(Operator op, CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, in, rl, ru, cl, cu, out, opcode, istr);
    }

    public static MatrixIndexingCPFileInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rangeReIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand();
                CPOperand rl = new CPOperand();
                CPOperand ru = new CPOperand();
                CPOperand cl = new CPOperand();
                CPOperand cu = new CPOperand();
                CPOperand out = new CPOperand();
                in.split(parts[1]);
                rl.split(parts[2]);
                ru.split(parts[3]);
                cl.split(parts[4]);
                cu.split(parts[5]);
                out.split(parts[6]);
                return new MatrixIndexingCPFileInstruction(new SimpleOperator(null), in, rl, ru, cl, cu, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (parts[0].equalsIgnoreCase("leftIndex")) {
            throw new DMLRuntimeException("Invalid opcode while parsing a MatrixIndexingCPFileInstruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingCPFileInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec).add(1);
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        if (mo.isPartitioned() && opcode.equalsIgnoreCase("rangeReIndex")) {
            MatrixFormatMetaData meta = (MatrixFormatMetaData)mo.getMetaData();
            MatrixCharacteristics mc = meta.getMatrixCharacteristics();
            String pfname = mo.getPartitionFileName(ixrange, mc.getRowsPerBlock(), mc.getColsPerBlock());
            if (MapReduceTool.existsFileOnHDFS(pfname)) {
                MatrixObject out = ec.getMatrixObject(this.output.getName());
                MatrixObject mobj = new MatrixObject(mo.getValueType(), pfname);
                mobj.setDataType(Expression.DataType.MATRIX);
                mobj.setVarName(out.getVarName());
                MatrixCharacteristics mcNew = null;
                switch (mo.getPartitionFormat()) {
                    case ROW_WISE: {
                        mcNew = new MatrixCharacteristics(1L, mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        mcNew = new MatrixCharacteristics(mo.getPartitionSize(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case COLUMN_WISE: {
                        mcNew = new MatrixCharacteristics(mc.getRows(), 1L, mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        mcNew = new MatrixCharacteristics(mc.getRows(), mo.getPartitionSize(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported partition format for CP_FILE rangeReIndex: " + (Object)((Object)mo.getPartitionFormat()));
                    }
                }
                MatrixFormatMetaData metaNew = new MatrixFormatMetaData(mcNew, meta.getOutputInfo(), meta.getInputInfo());
                mobj.setMetaData(metaNew);
                ec.setVariable(this.output.getName(), mobj);
            } else {
                MatrixBlock resultBlock = mo.readMatrixPartition(ixrange);
                ec.setMatrixOutput(this.output.getName(), resultBlock);
            }
        } else {
            throw new DMLRuntimeException("Invalid opcode or index predicate for MatrixIndexingCPFileInstruction: " + this.instString);
        }
    }
}

