/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.MapMultChain;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MMChainCPInstruction
extends UnaryCPInstruction {
    private MapMultChain.ChainType _type = null;
    private int _numThreads = -1;

    public MMChainCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, MapMultChain.ChainType type, int k, String opcode, String istr) {
        super(op, in1, in2, in3, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.MMChain;
        this._type = type;
        this._numThreads = k;
    }

    public static MMChainCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        if (parts.length == 6) {
            CPOperand out = new CPOperand(parts[3]);
            MapMultChain.ChainType type = MapMultChain.ChainType.valueOf(parts[4]);
            int k = Integer.parseInt(parts[5]);
            return new MMChainCPInstruction(null, in1, in2, null, out, type, k, opcode, str);
        }
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        MapMultChain.ChainType type = MapMultChain.ChainType.valueOf(parts[5]);
        int k = Integer.parseInt(parts[6]);
        return new MMChainCPInstruction(null, in1, in2, in3, out, type, k, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock X = ec.getMatrixInput(this.input1.getName());
        MatrixBlock v = ec.getMatrixInput(this.input2.getName());
        MatrixBlock w = this._type == MapMultChain.ChainType.XtwXv || this._type == MapMultChain.ChainType.XtXvy ? ec.getMatrixInput(this.input3.getName()) : null;
        MatrixBlock out = X.chainMatrixMultOperations(v, w, new MatrixBlock(), this._type, this._numThreads);
        ec.setMatrixOutput(this.output.getName(), out);
        ec.releaseMatrixInput(this.input1.getName());
        ec.releaseMatrixInput(this.input2.getName());
        if (w != null) {
            ec.releaseMatrixInput(this.input3.getName());
        }
    }

    public MapMultChain.ChainType getMMChainType() {
        return this._type;
    }
}

