/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.Arrays;
import org.apache.sysml.lops.MultipleCP;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarBuiltinMultipleCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public abstract class BuiltinMultipleCPInstruction
extends CPInstruction {
    public CPOperand output;
    public CPOperand[] inputs;

    public BuiltinMultipleCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(op, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.BuiltinMultiple;
        this.output = output;
        this.inputs = inputs;
    }

    public static BuiltinMultipleCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        String outputString = parts[parts.length - 1];
        CPOperand outputOperand = new CPOperand(outputString);
        String[] inputStrings = null;
        CPOperand[] inputOperands = null;
        if (parts.length > 2) {
            inputStrings = Arrays.copyOfRange(parts, 1, parts.length - 1);
            inputOperands = new CPOperand[parts.length - 2];
            for (int i = 0; i < inputStrings.length; ++i) {
                inputOperands[i] = new CPOperand(inputStrings[i]);
            }
        }
        if (MultipleCP.OperationType.PRINTF.toString().equalsIgnoreCase(opcode)) {
            Builtin func = Builtin.getBuiltinFnObject(opcode);
            return new ScalarBuiltinMultipleCPInstruction(new SimpleOperator(func), opcode, str, outputOperand, inputOperands);
        }
        throw new DMLRuntimeException("Opcode (" + opcode + ") not recognized in BuiltinMultipleCPInstruction");
    }
}

