/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.controlprogram.caching.ByteBuffer;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.util.LocalFileUtils;

public class LazyWriteBuffer {
    private static final long _limit;
    private static long _size;
    private static EvictionQueue _mQueue;
    private static FileCleaner _fClean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBlock(String fname, CacheBlock cb) throws IOException {
        boolean requiresWrite;
        long lSize = cb.getExactSerializedSize();
        boolean bl = requiresWrite = lSize > _limit || !ByteBuffer.isValidCapacity(lSize, cb);
        if (!requiresWrite) {
            ByteBuffer bbuff = new ByteBuffer(lSize);
            int numEvicted = 0;
            EvictionQueue evictionQueue = _mQueue;
            synchronized (evictionQueue) {
                while (_size + lSize >= _limit) {
                    Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirst();
                    String ftmp = entry.getKey();
                    ByteBuffer tmp = entry.getValue();
                    if (tmp == null) continue;
                    tmp.checkSerialized();
                    tmp.evictBuffer(ftmp);
                    tmp.freeMemory();
                    _size -= tmp.getSize();
                    ++numEvicted;
                }
                _mQueue.addLast(fname, bbuff);
                _size += lSize;
            }
            bbuff.serializeBlock(cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSBuffWrites();
                CacheStatistics.incrementFSWrites(numEvicted);
            }
        } else {
            LocalFileUtils.writeCacheBlockToLocal(fname, cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSWrites();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBlock(String fname) {
        boolean requiresDelete = true;
        EvictionQueue evictionQueue = _mQueue;
        synchronized (evictionQueue) {
            ByteBuffer ldata = (ByteBuffer)_mQueue.remove(fname);
            if (ldata != null) {
                _size -= ldata.getSize();
                requiresDelete = false;
                ldata.freeMemory();
            }
        }
        if (requiresDelete) {
            _fClean.deleteFile(fname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheBlock readBlock(String fname, boolean matrix) throws IOException {
        CacheBlock cb = null;
        ByteBuffer ldata = null;
        EvictionQueue evictionQueue = _mQueue;
        synchronized (evictionQueue) {
            ldata = (ByteBuffer)_mQueue.get(fname);
            if (CacheableData.CACHING_BUFFER_POLICY == RPolicy.LRU && ldata != null) {
                _mQueue.remove(fname);
                _mQueue.addLast(fname, ldata);
            }
        }
        if (ldata != null) {
            cb = ldata.deserializeBlock();
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSBuffHits();
            }
        } else {
            cb = LocalFileUtils.readCacheBlockFromLocal(fname, matrix);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSHits();
            }
        }
        return cb;
    }

    public static void init() {
        _mQueue = new EvictionQueue();
        _fClean = new FileCleaner();
        _size = 0L;
    }

    public static void cleanup() {
        if (_mQueue != null) {
            _mQueue.clear();
        }
        if (_fClean != null) {
            _fClean.close();
        }
    }

    public static long getWriteBufferSize() {
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        return (long)(0.15 * (double)maxMem);
    }

    public static void printStatus(String position) {
        System.out.println("WRITE BUFFER STATUS (" + position + ") --");
        System.out.println("\tWB: Buffer Meta Data: limit=" + _limit + ", size[bytes]=" + _size + ", size[elements]=" + _mQueue.size() + "/" + _mQueue.size());
        int count = _mQueue.size();
        for (Map.Entry entry : _mQueue.entrySet()) {
            String fname = (String)entry.getKey();
            ByteBuffer bbuff = (ByteBuffer)entry.getValue();
            System.out.println("\tWB: buffer element (" + count + "): " + fname + ", " + bbuff.getSize() + ", " + bbuff.isShallow());
            --count;
        }
    }

    public static void forceEviction() throws IOException {
        while (!_mQueue.isEmpty()) {
            Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirst();
            ByteBuffer tmp = entry.getValue();
            if (tmp == null) continue;
            tmp.checkSerialized();
            tmp.evictBuffer(entry.getKey());
            tmp.freeMemory();
        }
    }

    static {
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        _limit = (long)(0.15 * (double)maxMem);
    }

    private static class FileCleaner {
        private ExecutorService _pool = Executors.newCachedThreadPool();

        public void deleteFile(String fname) {
            this._pool.submit(new FileCleanerTask(fname));
        }

        public void close() {
            this._pool.shutdown();
        }

        private static class FileCleanerTask
        implements Runnable {
            private String _fname = null;

            public FileCleanerTask(String fname) {
                this._fname = fname;
            }

            @Override
            public void run() {
                LocalFileUtils.deleteFileIfExists(this._fname, true);
            }
        }
    }

    private static class EvictionQueue
    extends LinkedHashMap<String, ByteBuffer> {
        private static final long serialVersionUID = -5208333402581364859L;

        private EvictionQueue() {
        }

        public void addLast(String fname, ByteBuffer bbuff) {
            this.put(fname, bbuff);
        }

        public Map.Entry<String, ByteBuffer> removeFirst() {
            Iterator iter = this.entrySet().iterator();
            Map.Entry<String, ByteBuffer> entry = iter.next();
            iter.remove();
            return entry;
        }
    }

    public static enum RPolicy {
        FIFO,
        LRU;

    }
}

