/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class IfProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private String _predicateResultVar;
    private ArrayList<Instruction> _exitInstructions;
    private ArrayList<ProgramBlock> _childBlocksIfBody = new ArrayList();
    private ArrayList<ProgramBlock> _childBlocksElseBody = new ArrayList();

    public IfProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._predicateResultVar = this.findPredicateResultVar();
        this._exitInstructions = new ArrayList();
    }

    public ArrayList<ProgramBlock> getChildBlocksIfBody() {
        return this._childBlocksIfBody;
    }

    public void setChildBlocksIfBody(ArrayList<ProgramBlock> blocks) {
        this._childBlocksIfBody = blocks;
    }

    public void addProgramBlockIfBody(ProgramBlock pb) {
        this._childBlocksIfBody.add(pb);
    }

    public ArrayList<ProgramBlock> getChildBlocksElseBody() {
        return this._childBlocksElseBody;
    }

    public void setChildBlocksElseBody(ArrayList<ProgramBlock> blocks) {
        this._childBlocksElseBody = blocks;
    }

    public void addProgramBlockElseBody(ProgramBlock pb) {
        this._childBlocksElseBody.add(pb);
    }

    public void setExitInstructions2(ArrayList<Instruction> exitInstructions) {
        this._exitInstructions = exitInstructions;
    }

    public void setExitInstructions1(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    public void addExitInstruction(Instruction inst) {
        this._exitInstructions.add(inst);
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
        if (this._predicate != null && !this._predicate.isEmpty()) {
            this._predicateResultVar = this.findPredicateResultVar();
        }
    }

    public String getPredicateResultVar() {
        return this._predicateResultVar;
    }

    public void setPredicateResultVar(String resultVar) {
        this._predicateResultVar = resultVar;
    }

    public ArrayList<Instruction> getExitInstructions() {
        return this._exitInstructions;
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        int i;
        BooleanObject predResult = this.executePredicate(ec);
        if (predResult.getBooleanValue()) {
            try {
                for (i = 0; i < this._childBlocksIfBody.size(); ++i) {
                    ec.updateDebugState(i);
                    this._childBlocksIfBody.get(i).execute(ec);
                }
            }
            catch (DMLScriptException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating if statement body ", e);
            }
        }
        try {
            for (i = 0; i < this._childBlocksElseBody.size(); ++i) {
                ec.updateDebugState(i);
                this._childBlocksElseBody.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating else statement body ", e);
        }
        try {
            this.executeInstructions(this._exitInstructions, ec);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating if exit instructions ", e);
        }
    }

    private BooleanObject executePredicate(ExecutionContext ec) throws DMLRuntimeException {
        BooleanObject result = null;
        try {
            if (this._predicate != null && !this._predicate.isEmpty()) {
                if (this._sb != null) {
                    if (DMLScript.isActiveAM()) {
                        DMLAppMasterUtils.setupProgramBlockRemoteMaxMemory(this);
                    }
                    IfStatementBlock isb = (IfStatementBlock)this._sb;
                    Hop predicateOp = isb.getPredicateHops();
                    boolean recompile = isb.requiresPredicateRecompilation();
                    result = (BooleanObject)this.executePredicate(this._predicate, predicateOp, recompile, Expression.ValueType.BOOLEAN, ec);
                } else {
                    result = (BooleanObject)this.executePredicate(this._predicate, null, false, Expression.ValueType.BOOLEAN, ec);
                }
            } else {
                ScalarObject scalarResult = null;
                Data resultData = ec.getVariable(this._predicateResultVar);
                scalarResult = resultData == null ? ec.getScalarInput(this._predicateResultVar, Expression.ValueType.BOOLEAN, true) : ec.getScalarInput(this._predicateResultVar, Expression.ValueType.BOOLEAN, false);
                if (scalarResult instanceof StringObject) {
                    throw new DMLRuntimeException(this.printBlockErrorLocation() + "\nIf predicate variable " + this._predicateResultVar + " evaluated to string " + scalarResult + " which is not allowed for predicates in DML");
                }
                result = scalarResult instanceof BooleanObject ? (BooleanObject)scalarResult : new BooleanObject(scalarResult.getBooleanValue());
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the IF predicate.", ex);
        }
        return result;
    }

    private String findPredicateResultVar() {
        String result = null;
        for (Instruction si : this._predicate) {
            if (si.getType() == Instruction.INSTRUCTION_TYPE.CONTROL_PROGRAM && ((CPInstruction)si).getCPInstructionType() != CPInstruction.CPINSTRUCTION_TYPE.Variable) {
                result = ((ComputationCPInstruction)si).getOutputVariableName();
                continue;
            }
            if (!(si instanceof VariableCPInstruction) || !((VariableCPInstruction)si).isVariableCastInstruction()) continue;
            result = ((VariableCPInstruction)si).getOutputVariableName();
        }
        return result;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in if program block generated from if statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

