/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.Arrays;
import java.util.Iterator;

public final class BitmapDecoderOLE
implements Iterator<Integer> {
    private int _bmOff;
    private int _bmLen;
    private char[] _bmPtr;
    private int _blockIx;
    private int _blockStartOffset;
    private int _curBlockSize;
    private int _nextBmOffset;

    public BitmapDecoderOLE(char[] bmPtr, int off, int len) {
        this._bmOff = off;
        this._bmLen = len;
        this._bmPtr = bmPtr;
        this._blockIx = 0;
        this._blockStartOffset = 0;
        this._curBlockSize = this._bmPtr[this._bmOff + this._blockStartOffset];
        if (this._curBlockSize < 0) {
            throw new RuntimeException(String.format("Negative block size %d at position %d of %s", this._curBlockSize, this._blockStartOffset, Arrays.toString(bmPtr)));
        }
        this._nextBmOffset = 0;
        while (this._blockStartOffset < this._bmLen && this._nextBmOffset >= this._curBlockSize) {
            this.advanceToNextBlock();
        }
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new RuntimeException("No next offset existing.");
        }
        char offsetFromBlockBegin = this._bmPtr[this._bmOff + this._blockStartOffset + 1 + this._nextBmOffset];
        int ret = this._blockIx * 65536 + offsetFromBlockBegin;
        ++this._nextBmOffset;
        while (this._blockStartOffset < this._bmLen && this._nextBmOffset >= this._curBlockSize) {
            this.advanceToNextBlock();
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this._blockStartOffset < this._bmLen;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented for BitmapDecoderOLE.");
    }

    private void advanceToNextBlock() {
        this._blockStartOffset += 1 + this._curBlockSize;
        ++this._blockIx;
        if (this._blockStartOffset >= this._bmLen) {
            return;
        }
        this._curBlockSize = this._bmPtr[this._bmOff + this._blockStartOffset];
        if (this._curBlockSize < 0) {
            throw new RuntimeException(String.format("Negative block size %d at position %d of %s", this._curBlockSize, this._blockStartOffset, Arrays.toString(this._bmPtr)));
        }
        this._nextBmOffset = 0;
    }
}

