/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.math3.util.FastMath;
import org.apache.sysml.runtime.functionobjects.IntegerDivide;
import org.apache.sysml.runtime.functionobjects.Modulus;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;

public class LibSpoofPrimitives {
    private static IntegerDivide intDiv = IntegerDivide.getFnObject();
    private static Modulus mod = Modulus.getFnObject();
    private static ThreadLocal<LinkedList<double[]>> memPool = new ThreadLocal<LinkedList<double[]>>(){

        @Override
        protected LinkedList<double[]> initialValue() {
            return new LinkedList<double[]>();
        }
    };

    public static double dotProduct(double[] a, double[] b, int ai, int bi, int len) {
        return LibMatrixMult.dotProduct(a, b, ai, bi, len);
    }

    public static double dotProduct(double[] a, double[] b, int[] aix, int ai, int bi, int len) {
        return LibMatrixMult.dotProduct(a, b, aix, ai, bi, len);
    }

    public static void vectMultAdd(double[] a, double bval, double[] c, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(bval, a, c, bi, ci, len);
    }

    public static void vectMultAdd(double[] a, double bval, double[] c, int[] bix, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(bval, a, c, bix, bi, ci, len);
    }

    public static double[] vectMultWrite(double[] a, double bval, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        LibMatrixMult.vectMultiplyWrite(bval, a, c, bi, 0, len);
        return c;
    }

    public static double[] vectMultWrite(double[] a, double bval, int[] bix, int bi, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        LibMatrixMult.vectMultiplyAdd(bval, a, c, bix, bi, 0, len);
        return c;
    }

    public static void vectWrite(double[] a, double[] c, int ci, int len) {
        System.arraycopy(a, 0, c, ci, len);
    }

    public static double vectSum(double[] a, int ai, int len) {
        int i;
        double val = 0.0;
        int bn = len % 8;
        for (i = ai; i < ai + bn; ++i) {
            val += a[i];
        }
        for (i = ai + bn; i < ai + len; i += 8) {
            val += a[i + 0] + a[i + 1] + a[i + 2] + a[i + 3] + a[i + 4] + a[i + 5] + a[i + 6] + a[i + 7];
        }
        return val;
    }

    public static double vectSum(double[] avals, int[] aix, int ai, int len) {
        return LibSpoofPrimitives.vectSum(avals, ai, len);
    }

    public static double vectMin(double[] a, int ai, int len) {
        double val = Double.MAX_VALUE;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.min(a[i], val);
        }
        return val;
    }

    public static double vectMin(double[] avals, int[] aix, int ai, int len) {
        double val = Double.MAX_VALUE;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.min(avals[aix[i]], val);
        }
        return val;
    }

    public static double vectMax(double[] a, int ai, int len) {
        double val = -1.7976931348623157E308;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.max(a[i], val);
        }
        return val;
    }

    public static double vectMax(double[] avals, int[] aix, int ai, int len) {
        double val = -1.7976931348623157E308;
        for (int i = ai; i < ai + len; ++i) {
            val = Math.max(avals[aix[i]], val);
        }
        return val;
    }

    public static void vectDivAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + a[j] / bval;
        }
    }

    public static void vectDivAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j] / bval;
        }
    }

    public static double[] vectDivWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] / bval;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectDivWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] / bval;
        }
        return c;
    }

    public static void vectMinusAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (a[j] - bval);
        }
    }

    public static void vectMinusAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] - bval);
        }
    }

    public static double[] vectMinusWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] - bval;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMinusWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] - bval;
        }
        return c;
    }

    public static void vectPlusAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (a[j] + bval);
        }
    }

    public static void vectPlusAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] + bval);
        }
    }

    public static double[] vectPlusWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] + bval;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPlusWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] + bval;
        }
        return c;
    }

    public static void vectPowAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.pow(a[j], bval);
        }
    }

    public static void vectPowAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.pow(a[j], bval);
        }
    }

    public static double[] vectPowWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.pow(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPowWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.pow(a[j], bval);
        }
        return c;
    }

    public static void vectMinAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.min(a[j], bval);
        }
    }

    public static void vectMinAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.min(a[j], bval);
        }
    }

    public static double[] vectMinWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.min(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMinWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.min(a[j], bval);
        }
        return c;
    }

    public static void vectMaxAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.max(a[j], bval);
        }
    }

    public static void vectMaxAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.max(a[j], bval);
        }
    }

    public static double[] vectMaxWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.max(a[ai], bval);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMaxWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.max(a[j], bval);
        }
        return c;
    }

    public static void vectExpAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.exp((double)a[j]);
        }
    }

    public static void vectExpAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.exp((double)a[j]);
        }
    }

    public static double[] vectExpWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.exp((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectExpWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = FastMath.exp((double)a[j]);
        }
        return c;
    }

    public static void vectLogAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.log((double)a[j]);
        }
    }

    public static void vectLogAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.log((double)a[j]);
        }
    }

    public static double[] vectLogWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.log((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLogWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = FastMath.log((double)a[j]);
        }
        return c;
    }

    public static void vectAbsAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.abs(a[j]);
        }
    }

    public static void vectAbsAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.log(a[j]);
        }
    }

    public static double[] vectAbsWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.log(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectAbsWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.log(a[j]);
        }
        return c;
    }

    public static void vectRoundAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (double)Math.round(a[j]);
        }
    }

    public static void vectRoundAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (double)Math.round(a[j]);
        }
    }

    public static double[] vectRoundWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.round(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectRoundWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.round(a[j]);
        }
        return c;
    }

    public static void vectCeilAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.ceil((double)a[j]);
        }
    }

    public static void vectCeilAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.ceil((double)a[j]);
        }
    }

    public static double[] vectCeilWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.ceil((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectCeilWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = FastMath.ceil((double)a[j]);
        }
        return c;
    }

    public static void vectFloorAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.floor((double)a[j]);
        }
    }

    public static void vectFloorAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.floor((double)a[j]);
        }
    }

    public static double[] vectFloorWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.floor((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectFloorWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = FastMath.floor((double)a[j]);
        }
        return c;
    }

    public static void vectSignAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + FastMath.signum((double)a[j]);
        }
    }

    public static void vectSignAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + FastMath.signum((double)a[j]);
        }
    }

    public static double[] vectSignWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = FastMath.signum((double)a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSignWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = FastMath.signum((double)a[j]);
        }
        return c;
    }

    public static void vectPow2Add(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + a[j] * a[j];
        }
    }

    public static void vectPow2Add(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + a[j] * a[j];
        }
    }

    public static double[] vectPow2Write(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] * a[ai];
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectPow2Write(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] * a[j];
        }
        return c;
    }

    public static void vectMult2Add(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + (a[j] + a[j]);
        }
    }

    public static void vectMult2Add(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] + a[j]);
        }
    }

    public static double[] vectMult2Write(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] + a[ai];
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectMult2Write(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] + a[j];
        }
        return c;
    }

    public static void vectSqrtAdd(double[] a, double[] c, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci++;
            c[n] = c[n] + Math.sqrt(a[j]);
        }
    }

    public static void vectSqrtAdd(double[] a, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + Math.sqrt(a[j]);
        }
    }

    public static double[] vectSqrtWrite(double[] a, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = Math.sqrt(a[ai]);
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectSqrtWrite(double[] a, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = Math.sqrt(a[j]);
        }
        return c;
    }

    public static void vectEqualAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] == bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectEqualAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] == bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectEqualWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] == bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectEqualWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] == bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static void vectNotequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] != bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectNotequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] != bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectNotequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] != bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectNotequalWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] != bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static void vectLessAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] < bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectLessAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] < bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectLessWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] < bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLessWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] < bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static void vectLessequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] <= bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectLessequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] <= bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectLessequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] <= bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectLessequalWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] <= bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static void vectGreaterAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] > bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectGreaterAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] > bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectGreaterWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] > bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectGreaterWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] > bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static void vectGreaterequalAdd(double[] a, double bval, double[] c, int ai, int ci, int len) {
        int j = ai;
        while (j < ai + len) {
            int n = ci;
            c[n] = c[n] + (a[j] >= bval ? 1.0 : 0.0);
            ++j;
            ++ci;
        }
    }

    public static void vectGreaterequalAdd(double[] a, double bval, double[] c, int[] aix, int ai, int ci, int len) {
        for (int j = ai; j < ai + len; ++j) {
            int n = ci + aix[j];
            c[n] = c[n] + (a[j] >= bval ? 1.0 : 0.0);
        }
    }

    public static double[] vectGreaterequalWrite(double[] a, double bval, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, false);
        int j = 0;
        while (j < len) {
            c[j] = a[ai] >= bval ? 1.0 : 0.0;
            ++j;
            ++ai;
        }
        return c;
    }

    public static double[] vectGreaterequalWrite(double[] a, double bval, int[] aix, int ai, int len) {
        double[] c = LibSpoofPrimitives.allocVector(len, true);
        for (int j = ai; j < ai + len; ++j) {
            c[aix[j]] = a[j] >= bval ? 1.0 : 0.0;
        }
        return c;
    }

    public static double intDiv(double in1, double in2) {
        return intDiv.execute(in1, in2);
    }

    public static double mod(double in1, double in2) {
        return mod.execute(in1, in2);
    }

    public static void setupThreadLocalMemory(int numVectors, int len) {
        LinkedList<double[]> list = new LinkedList<double[]>();
        for (int i = 0; i < numVectors; ++i) {
            list.addLast(new double[len]);
        }
        memPool.set(list);
    }

    public static void cleanupThreadLocalMemory() {
        memPool.remove();
    }

    private static double[] allocVector(int len, boolean reset) {
        LinkedList<double[]> list = memPool.get();
        if (list.isEmpty()) {
            return new double[len];
        }
        double[] tmp = list.removeFirst();
        list.addLast(tmp);
        if (reset) {
            Arrays.fill(tmp, 0.0);
        }
        return tmp;
    }
}

