/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;

public class PrintStatement
extends Statement {
    protected PRINTTYPE _type;
    protected List<Expression> expressions;

    private static PRINTTYPE getPrintType(String type, List<Expression> expressions) throws LanguageException {
        if (type.equalsIgnoreCase("print")) {
            if (expressions.size() == 1) {
                return PRINTTYPE.PRINT;
            }
            return PRINTTYPE.PRINTF;
        }
        if (type.equalsIgnoreCase("stop")) {
            return PRINTTYPE.STOP;
        }
        throw new LanguageException("Unknown statement type: " + type);
    }

    public PrintStatement(String type, List<Expression> expressions, int beginLine, int beginCol, int endLine, int endCol) throws LanguageException {
        this(PrintStatement.getPrintType(type, expressions), expressions);
        this.setBeginLine(beginLine);
        this.setBeginColumn(beginCol);
        this.setEndLine(endLine);
        this.setEndColumn(endCol);
    }

    public PrintStatement(PRINTTYPE type, List<Expression> expressions) throws LanguageException {
        this._type = type;
        this.expressions = expressions;
    }

    @Override
    public Statement rewriteStatement(String prefix) throws LanguageException {
        ArrayList<Expression> newExpressions = new ArrayList<Expression>();
        for (Expression oldExpression : this.expressions) {
            Expression newExpression = oldExpression.rewriteExpression(prefix);
            newExpressions.add(newExpression);
        }
        PrintStatement retVal = new PrintStatement(this._type, newExpressions);
        retVal.setBeginLine(this.getBeginLine());
        retVal.setBeginColumn(this.getBeginColumn());
        retVal.setEndLine(this.getEndLine());
        retVal.setEndColumn(this.getEndColumn());
        return retVal;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)((Object)this._type) + "(");
        if (this._type == PRINTTYPE.PRINT || this._type == PRINTTYPE.STOP) {
            Expression expression = this.expressions.get(0);
            if (expression instanceof StringIdentifier) {
                sb.append("\"");
                sb.append(expression.toString());
                sb.append("\"");
            } else {
                sb.append(expression.toString());
            }
        } else if (this._type == PRINTTYPE.PRINTF) {
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression expression;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((expression = this.expressions.get(i)) instanceof StringIdentifier) {
                    sb.append("\"");
                    sb.append(expression.toString());
                    sb.append("\"");
                    continue;
                }
                sb.append(expression.toString());
            }
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet variableSet = new VariableSet();
        for (Expression expression : this.expressions) {
            VariableSet variablesRead = expression.variablesRead();
            variableSet.addVariables(variablesRead);
        }
        return variableSet;
    }

    @Override
    public VariableSet variablesUpdated() {
        return new VariableSet();
    }

    @Override
    public boolean controlStatement() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            DMLBreakpointManager.insertBreakpoint(this.expressions.get(0).getBeginLine());
            return true;
        }
        return this.getType() == PRINTTYPE.STOP;
    }

    public PRINTTYPE getType() {
        return this._type;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public static enum PRINTTYPE {
        PRINT,
        PRINTF,
        STOP;

    }
}

