/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.util.LocalFileUtils;

public abstract class ParserWrapper {
    protected boolean atLeastOneError = false;
    protected boolean atLeastOneWarning = false;
    protected List<CustomErrorListener.ParseIssue> parseIssues;

    public abstract DMLProgram parse(String var1, String var2, Map<String, String> var3) throws ParseException;

    public static StatementBlock getStatementBlock(Statement current) {
        StatementBlock blk = null;
        if (current instanceof ParForStatement) {
            blk = new ParForStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof ForStatement) {
            blk = new ForStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof IfStatement) {
            blk = new IfStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof WhileStatement) {
            blk = new WhileStatementBlock();
            blk.addStatement(current);
        } else {
            blk = new StatementBlock();
            blk.addStatement(current);
        }
        return blk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readDMLScript(String script, Log LOG) throws IOException, LanguageException {
        String dmlScriptStr = null;
        if (script == null) {
            throw new LanguageException("DML script path was not specified!");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            if (script.startsWith("hdfs:") || script.startsWith("gpfs:")) {
                LOG.debug((Object)("Looking for the following file in HDFS or GPFS: " + script));
                if (!LocalFileUtils.validateExternalFilename(script, true)) {
                    throw new LanguageException("Invalid (non-trustworthy) hdfs filename.");
                }
                FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
                Path scriptPath = new Path(script);
                in = new BufferedReader(new InputStreamReader((InputStream)fs.open(scriptPath)));
            } else {
                LOG.debug((Object)("Looking for the following file in the local file system: " + script));
                if (!LocalFileUtils.validateExternalFilename(script, false)) {
                    throw new LanguageException("Invalid (non-trustworthy) local filename.");
                }
                in = new BufferedReader(new FileReader(script));
            }
            String tmp = null;
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
                sb.append("\n");
            }
            IOUtilFunctions.closeSilently(in);
        }
        catch (IOException ex) {
            String s;
            String resPath = ParserWrapper.scriptPathToResourcePath(script);
            LOG.debug((Object)("Looking for the following resource from the SystemML jar file: " + resPath));
            InputStream is = ParserWrapper.class.getResourceAsStream(resPath);
            if (is == null) {
                if (resPath.startsWith("/scripts")) {
                    LOG.error((Object)("Failed to read from the file system ('" + script + "') or SystemML jar file ('" + resPath + "')"));
                    throw ex;
                }
                String scriptsResPath = "/scripts" + resPath;
                LOG.debug((Object)("Looking for the following resource from the SystemML jar file: " + scriptsResPath));
                is = ParserWrapper.class.getResourceAsStream(scriptsResPath);
                if (is == null) {
                    LOG.error((Object)("Failed to read from the file system ('" + script + "') or SystemML jar file ('" + resPath + "' or '" + scriptsResPath + "')"));
                    throw ex;
                }
            }
            String string = s = IOUtils.toString((InputStream)is);
            return string;
        }
        finally {
            IOUtilFunctions.closeSilently(in);
        }
        dmlScriptStr = sb.toString();
        return dmlScriptStr;
    }

    private static String scriptPathToResourcePath(String scriptPath) {
        String resPath = scriptPath;
        if (resPath.startsWith(".")) {
            resPath = resPath.substring(1);
        } else if (!resPath.startsWith("\\") && !resPath.startsWith("/")) {
            resPath = "/" + resPath;
        }
        resPath = resPath.replace("\\", "/");
        return resPath;
    }

    public boolean isAtLeastOneError() {
        return this.atLeastOneError;
    }

    public boolean isAtLeastOneWarning() {
        return this.atLeastOneWarning;
    }

    public List<CustomErrorListener.ParseIssue> getParseIssues() {
        return this.parseIssues;
    }
}

