/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class PlusMult
extends Lop {
    public PlusMult(Lop input1, Lop input2, Lop input3, Hop.OpOp3 op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.PlusMult, dt, vt);
        if (op == Hop.OpOp3.MINUS_MULT) {
            this.type = Lop.Type.MinusMult;
        }
        this.init(input1, input2, input3, et);
    }

    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK || et == LopProperties.ExecType.GPU) {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = PlusMult";
    }

    public String getOpString() {
        return this.type == Lop.Type.PlusMult ? "+*" : "-*";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpString());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append(this.getInputs().get(1).prepScalarLabel());
        } else {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(input2));
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input1, int input2, int input3, int output) {
        return this.getInstructions(String.valueOf(input1), String.valueOf(input2), String.valueOf(input3), String.valueOf(output));
    }
}

