/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CoVariance
extends Lop {
    public CoVariance(Lop input1, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.CoVariance, dt, vt);
        this.init(input1, null, null, et);
    }

    public CoVariance(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        this(input1, input2, null, dt, vt, et);
    }

    public CoVariance(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.CoVariance, dt, vt);
        this.init(input1, input2, input3, et);
    }

    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) throws LopsException {
        this.addInput(input1);
        input1.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = true;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.CM_COV);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            definesMRJob = false;
            if (input2 == null) {
                throw new LopsException(this.printErrorLocation() + "Invalid inputs to covariance lop.");
            }
            this.addInput(input2);
            input2.addOutput(this);
            if (input3 != null) {
                this.addInput(input3);
                input3.addOutput(this);
            }
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = coVariance";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("cov");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (input2 != null) {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
            sb.append("\u00b0");
        }
        if (input3 != null) {
            sb.append(this.getInputs().get(2).prepInputOperand(input3));
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), null, null, String.valueOf(output_index));
    }
}

