/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteCompressedReblock
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return null;
        }
        boolean compress = ConfigurationManager.getDMLConfig().getBooleanValue("compressed.linalg");
        if (compress) {
            for (Hop h : roots) {
                this.rule_CompressedReblock(h);
            }
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        return root;
    }

    private void rule_CompressedReblock(Hop hop) throws HopsException {
        for (Hop hi : hop.getInput()) {
            if (hi.isVisited()) continue;
            this.rule_CompressedReblock(hi);
        }
        if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD && hop.getDim1() > 1L && hop.getDim2() > 1L) {
            hop.setRequiresCompression(true);
        }
        hop.setVisited();
    }
}

