/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysml.hops.codegen.SpoofFusedOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.runtime.codegen.SpoofRowwise;

public class CNodeRow
extends CNodeTpl {
    private static final String TEMPLATE = "package codegen;\nimport org.apache.sysml.runtime.codegen.LibSpoofPrimitives;\nimport org.apache.sysml.runtime.codegen.SpoofRowwise;\nimport org.apache.sysml.runtime.codegen.SpoofRowwise.RowType;\nimport org.apache.commons.math3.util.FastMath;\n\npublic final class %TMP% extends SpoofRowwise { \n  public %TMP%() {\n    super(RowType.%TYPE%, %VECT_MEM%);\n  }\n  protected void genexecRowDense( double[] a, int ai, double[][] b, double[] scalars, double[] c, int len, int rowIndex ) { \n%BODY_dense%  }\n  protected void genexecRowSparse( double[] avals, int[] aix, int ai, double[][] b, double[] scalars, double[] c, int len, int rowIndex ) { \n%BODY_sparse%  }\n}\n";
    private static final String TEMPLATE_ROWAGG_OUT = "    c[rowIndex] = %IN%;\n";
    private static final String TEMPLATE_NOAGG_OUT = "    LibSpoofPrimitives.vectWrite(%IN%, c, rowIndex*len, len);\n";
    private SpoofRowwise.RowType _type = null;
    private int _numVectors = -1;

    public CNodeRow(ArrayList<CNode> inputs, CNode output) {
        super(inputs, output);
    }

    public void setNumVectorIntermediates(int num) {
        this._numVectors = num;
    }

    public int getNumVectorIntermediates() {
        return this._numVectors;
    }

    public void setRowType(SpoofRowwise.RowType type) {
        this._type = type;
        this._hash = 0;
    }

    public SpoofRowwise.RowType getRowType() {
        return this._type;
    }

    @Override
    public String codegen(boolean sparse) {
        String tmp = TEMPLATE;
        this.rReplaceDataNode(this._output, (CNode)this._inputs.get(0), "a");
        this.renameInputs(this._inputs, 1);
        String tmpDense = this._output.codegen(false) + this.getOutputStatement(this._output.getVarname());
        this._output.resetGenerated();
        String tmpSparse = this._output.codegen(true) + this.getOutputStatement(this._output.getVarname());
        tmp = tmp.replaceAll("%TMP%", this.createVarname());
        tmp = tmp.replaceAll("%BODY_dense%", tmpDense);
        tmp = tmp.replaceAll("%BODY_sparse%", tmpSparse);
        tmp = tmp.replaceAll("%OUT%", "c");
        tmp = tmp.replaceAll("%POSOUT%", "0");
        tmp = tmp.replaceAll("%LEN%", "len");
        tmp = tmp.replaceAll("%TYPE%", this._type.name());
        tmp = tmp.replaceAll("%VECT_MEM%", String.valueOf(this._numVectors));
        return tmp;
    }

    private String getOutputStatement(String varName) {
        if (!this._type.isColumnAgg()) {
            String tmp = this._type == SpoofRowwise.RowType.NO_AGG ? TEMPLATE_NOAGG_OUT : TEMPLATE_ROWAGG_OUT;
            return tmp.replace("%IN%", varName);
        }
        return "";
    }

    @Override
    public void setOutputDims() {
    }

    @Override
    public SpoofFusedOp.SpoofOutputDimsType getOutputDimType() {
        switch (this._type) {
            case NO_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.INPUT_DIMS;
            }
            case ROW_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.ROW_DIMS;
            }
            case COL_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.COLUMN_DIMS_COLS;
            }
            case COL_AGG_T: {
                return SpoofFusedOp.SpoofOutputDimsType.COLUMN_DIMS_ROWS;
            }
        }
        throw new RuntimeException("Unsupported row type: " + this._type.toString());
    }

    @Override
    public CNodeTpl clone() {
        CNodeRow tmp = new CNodeRow(this._inputs, this._output);
        tmp.setRowType(this._type);
        tmp.setNumVectorIntermediates(this._numVectors);
        return tmp;
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            int h1 = super.hashCode();
            int h2 = this._type.hashCode();
            int h3 = this._numVectors;
            this._hash = Arrays.hashCode(new int[]{h1, h2, h3});
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeRow)) {
            return false;
        }
        CNodeRow that = (CNodeRow)o;
        return super.equals(o) && this._type == that._type && this._numVectors == that._numVectors && CNodeRow.equalInputReferences(this._output, that._output, (ArrayList<CNode>)this._inputs, (ArrayList<CNode>)that._inputs);
    }

    @Override
    public String getTemplateInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("SPOOF ROWAGGREGATE [type=");
        sb.append(this._type.name());
        sb.append(", reqVectMem=");
        sb.append(this._numVectors);
        sb.append("]");
        return sb.toString();
    }
}

