/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.debug.DMLDebugger;
import org.apache.sysml.debug.DMLDebuggerException;
import org.apache.sysml.debug.DMLDebuggerProgramInfo;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.codegen.SpoofCompiler;
import org.apache.sysml.hops.globalopt.GlobalOptimizerWrapper;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserFactory;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CleanupMR;
import org.apache.sysml.runtime.matrix.data.LibMatrixDNN;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.GPUStatistics;
import org.apache.sysml.utils.Statistics;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.DMLYarnClientProxy;

public class DMLScript {
    public static RUNTIME_PLATFORM rtplatform = OptimizerUtils.getDefaultExecutionMode();
    public static boolean STATISTICS = false;
    public static int STATISTICS_COUNT = 10;
    public static boolean ENABLE_DEBUG_MODE = false;
    public static boolean USE_LOCAL_SPARK_CONFIG = false;
    public static String DML_FILE_PATH_ANTLR_PARSER = null;
    public static Explain.ExplainType EXPLAIN = Explain.ExplainType.NONE;
    public static ScriptType SCRIPT_TYPE = ScriptType.DML;
    public static boolean USE_ACCELERATOR = false;
    public static boolean FORCE_ACCELERATOR = false;
    public static boolean _suppressPrint2Stdout = false;
    public static String _uuid = IDHandler.createDistributedUniqueID();
    public static boolean _activeAM = false;
    private static final Log LOG = LogFactory.getLog((String)DMLScript.class.getName());
    public static String USAGE = "Usage is " + DMLScript.class.getCanonicalName() + " -f <filename> [-options] ([-args | -nvargs] <args-list>)? \n   -f: <filename> will be interpreted as a filename path (if <filename> is prefixed\n         with hdfs or gpfs it is read from DFS, otherwise from local file system)\n   -python: (optional) parses Python-like DML\n   -debug: (optional) run in debug mode\n   -gpu: <flags> (optional) use acceleration whenever possible. Current version only supports CUDA.\n\t\t\tSupported <flags> for this mode is force=(true|false)\n   -exec: <mode> (optional) execution mode (hadoop, singlenode, [hybrid], hybrid_spark)\n   -explain: <type> (optional) explain plan (hops, [runtime], recompile_hops, recompile_runtime)\n   -stats: <count> (optional) monitor and report caching/recompilation statistics, default heavy hitter count is 10\n   -clean: (optional) cleanup all SystemML working directories (FS, DFS).\n         All other flags are ignored in this mode. \n   -config: (optional) use config file <config_filename> (default: use parameter\n         values in default SystemML-config.xml config file; if <config_filename> is\n         prefixed with hdfs or gpfs it is read from DFS, otherwise from local file system)\n   -args: (optional) parameterize DML script with contents of [args list], ALL args\n         after -args flag, each argument must be an unnamed-argument, where 1st value\n         after -args will replace $1 in DML script, 2nd value will replace $2, etc.\n   -nvargs: (optional) parameterize DML script with contents of [args list], ALL args\n         after -nvargs flag, each argument must be be named-argument of form argName=argValue,\n         where value will replace $argName in DML script, argName must be a valid DML variable\n         name (start with letter, contain only letters, numbers, or underscores).\n   <args-list>: (optional) args to DML script \n   -? | -help: (optional) show this help message \n";

    public static String getUUID() {
        return _uuid;
    }

    public static void setUUID(String uuid) {
        _uuid = uuid;
    }

    public static boolean suppressPrint2Stdout() {
        return _suppressPrint2Stdout;
    }

    public static void setActiveAM() {
        _activeAM = true;
    }

    public static boolean isActiveAM() {
        return _activeAM;
    }

    public static void main(String[] args) throws IOException, DMLException {
        Configuration conf = new Configuration((Configuration)ConfigurationManager.getCachedJobConf());
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        try {
            DMLScript.executeScript(conf, otherArgs);
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
        }
        catch (DMLScriptException e) {
            System.err.println(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean executeScript(Configuration conf, String[] args) throws DMLException {
        if (args.length == 0 || args.length == 1 && (args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-?"))) {
            System.err.println(USAGE);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("-clean")) {
            DMLScript.cleanSystemMLWorkspace();
            return true;
        }
        if (args.length < 2) {
            System.err.println("ERROR: Unrecognized invocation arguments.");
            System.err.println(USAGE);
            return false;
        }
        if (!args[0].equals("-f") && !args[0].equals("-s")) {
            System.err.println("ERROR: First argument must be either -f or -s");
            System.err.println(USAGE);
            return false;
        }
        RUNTIME_PLATFORM oldrtplatform = rtplatform;
        Explain.ExplainType oldexplain = EXPLAIN;
        ENABLE_DEBUG_MODE = false;
        boolean parsePyDML = false;
        try {
            String fnameOptConfig = null;
            String[] scriptArgs = null;
            boolean namedScriptArgs = false;
            for (int i = 2; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-explain")) {
                    EXPLAIN = Explain.ExplainType.RUNTIME;
                    if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
                    EXPLAIN = Explain.parseExplainType(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-stats")) {
                    STATISTICS = true;
                    if (args.length <= i + 1 || args[i + 1].startsWith("-")) continue;
                    STATISTICS_COUNT = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-exec")) {
                    if ((rtplatform = DMLScript.parseRuntimePlatform(args[++i])) != null) continue;
                    boolean bl = false;
                    return bl;
                }
                if (args[i].startsWith("-config=")) {
                    fnameOptConfig = args[i].substring(8).replaceAll("\"", "");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-config")) {
                    fnameOptConfig = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-debug")) {
                    ENABLE_DEBUG_MODE = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gpu")) {
                    USE_ACCELERATOR = true;
                    if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                        String flag;
                        if (!(flag = args[++i]).startsWith("force=")) throw new DMLRuntimeException("Unsupported flag for -gpu:" + flag);
                        String[] flagOptions = flag.split("=");
                        if (flagOptions.length != 2) throw new DMLRuntimeException("Unsupported \"force\" option for -gpu:" + flag);
                        FORCE_ACCELERATOR = Boolean.parseBoolean(flagOptions[1]);
                    }
                    GPUContext.getGPUContext();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-python")) {
                    parsePyDML = true;
                    continue;
                }
                if (args[i].startsWith("-args") || args[i].startsWith("-nvargs")) {
                    namedScriptArgs = args[i].startsWith("-nvargs");
                    scriptArgs = new String[args.length - ++i];
                    System.arraycopy(args, i, scriptArgs, 0, scriptArgs.length);
                    break;
                }
                System.err.println("ERROR: Unknown argument: " + args[i]);
                boolean flag = false;
                return flag;
            }
            if (!ENABLE_DEBUG_MODE) {
                DMLScript.setLoggingProperties(conf);
            }
            if (StringUtils.endsWithIgnoreCase((String)args[1], (String)".pydml")) {
                parsePyDML = true;
            }
            String dmlScriptStr = DMLScript.readDMLScript(args[0], args[1]);
            Map<String, String> argVals = DMLScript.createArgumentsMap(namedScriptArgs, scriptArgs);
            DML_FILE_PATH_ANTLR_PARSER = args[1];
            DMLScript.printInvocationInfo(args[1], fnameOptConfig, argVals);
            if (ENABLE_DEBUG_MODE) {
                DMLScript.launchDebugger(dmlScriptStr, fnameOptConfig, argVals, parsePyDML);
                return true;
            } else {
                DMLScript.execute(dmlScriptStr, fnameOptConfig, argVals, args, parsePyDML);
            }
            return true;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to execute DML script.", (Throwable)ex);
            throw new DMLException(ex);
        }
        finally {
            rtplatform = oldrtplatform;
            EXPLAIN = oldexplain;
        }
    }

    protected static Map<String, String> createArgumentsMap(boolean hasNamedArgs, String[] args) throws LanguageException {
        HashMap<String, String> argMap = new HashMap<String, String>();
        if (args == null) {
            return argMap;
        }
        for (int i = 1; i <= args.length; ++i) {
            String arg = args[i - 1];
            if (arg.equalsIgnoreCase("-l") || arg.equalsIgnoreCase("-log") || arg.equalsIgnoreCase("-v") || arg.equalsIgnoreCase("-visualize") || arg.equalsIgnoreCase("-explain") || arg.equalsIgnoreCase("-debug") || arg.equalsIgnoreCase("-stats") || arg.equalsIgnoreCase("-exec") || arg.equalsIgnoreCase("-debug") || arg.startsWith("-config=")) {
                throw new LanguageException("-args or -nvargs must be the final argument for DMLScript!");
            }
            if (hasNamedArgs) {
                String[] argPieces = arg.split("=");
                if (argPieces.length < 2) {
                    throw new LanguageException("for -nvargs option, elements in arg list must be named and have form argName=argValue");
                }
                String argName = argPieces[0];
                StringBuilder sb = new StringBuilder();
                for (int jj = 1; jj < argPieces.length; ++jj) {
                    sb.append(argPieces[jj]);
                }
                String varNameRegex = "^[a-zA-Z]([a-zA-Z0-9_])*$";
                if (!argName.matches(varNameRegex)) {
                    throw new LanguageException("argName " + argName + " must be a valid variable name in DML. Valid variable names in DML start with upper-case or lower-case letter, and contain only letters, digits, or underscores");
                }
                argMap.put("$" + argName, sb.toString());
                continue;
            }
            argMap.put("$" + i, arg);
        }
        return argMap;
    }

    protected static String readDMLScript(String argname, String script) throws IOException, LanguageException {
        String dmlScriptStr;
        block13: {
            block11: {
                boolean fromFile = argname.equals("-f");
                if (!fromFile) break block11;
                if (script == null) {
                    throw new LanguageException("DML script path was not specified!");
                }
                StringBuilder sb = new StringBuilder();
                BufferedReader in = null;
                try {
                    if (script.startsWith("hdfs:") || script.startsWith("gpfs:")) {
                        if (!LocalFileUtils.validateExternalFilename(script, true)) {
                            throw new LanguageException("Invalid (non-trustworthy) hdfs filename.");
                        }
                        FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
                        Path scriptPath = new Path(script);
                        in = new BufferedReader(new InputStreamReader((InputStream)fs.open(scriptPath)));
                    } else {
                        if (!LocalFileUtils.validateExternalFilename(script, false)) {
                            throw new LanguageException("Invalid (non-trustworthy) local filename.");
                        }
                        in = new BufferedReader(new FileReader(script));
                    }
                    String tmp = null;
                    while ((tmp = in.readLine()) != null) {
                        sb.append(tmp);
                        sb.append("\n");
                    }
                }
                catch (IOException ex) {
                    try {
                        LOG.error((Object)"Failed to read the script from the file system", (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(in);
                        throw throwable;
                    }
                }
                IOUtilFunctions.closeSilently(in);
                dmlScriptStr = sb.toString();
                break block13;
            }
            if (script == null) {
                throw new LanguageException("DML script was not specified!");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(script.getBytes());
            Scanner scan = new Scanner(is);
            dmlScriptStr = scan.useDelimiter("\\A").next();
            scan.close();
        }
        return dmlScriptStr;
    }

    private static RUNTIME_PLATFORM parseRuntimePlatform(String platform) {
        RUNTIME_PLATFORM lrtplatform = null;
        if (platform.equalsIgnoreCase("hadoop")) {
            lrtplatform = RUNTIME_PLATFORM.HADOOP;
        } else if (platform.equalsIgnoreCase("singlenode")) {
            lrtplatform = RUNTIME_PLATFORM.SINGLE_NODE;
        } else if (platform.equalsIgnoreCase("hybrid")) {
            lrtplatform = RUNTIME_PLATFORM.HYBRID;
        } else if (platform.equalsIgnoreCase("spark")) {
            lrtplatform = RUNTIME_PLATFORM.SPARK;
        } else if (platform.equalsIgnoreCase("hybrid_spark")) {
            lrtplatform = RUNTIME_PLATFORM.HYBRID_SPARK;
        } else {
            System.err.println("ERROR: Unknown runtime platform: " + platform);
        }
        return lrtplatform;
    }

    private static void setLoggingProperties(Configuration conf) {
        String debug = conf.get("systemml.logging");
        if (debug == null) {
            debug = System.getProperty("systemml.logging");
        }
        if (debug != null) {
            if (debug.equalsIgnoreCase("debug")) {
                Logger.getLogger((String)"org.apache.sysml").setLevel(Level.DEBUG);
            } else if (debug.equalsIgnoreCase("trace")) {
                Logger.getLogger((String)"org.apache.sysml").setLevel(Level.TRACE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, String[] allArgs, boolean parsePyDML) throws ParseException, IOException, DMLRuntimeException, LanguageException, HopsException, LopsException {
        SCRIPT_TYPE = parsePyDML ? ScriptType.PYDML : ScriptType.DML;
        DMLScript.printStartExecInfo(dmlScriptStr);
        DMLConfig dmlconf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(dmlconf);
        CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
        ConfigurationManager.setGlobalConfig(cconf);
        LOG.debug((Object)("\nDML config: \n" + dmlconf.getConfigInfo()));
        if (dmlconf.getBooleanValue("dml.yarn.appmaster")) {
            DMLAppMasterUtils.setupConfigRemoteMaxMemory(dmlconf);
        }
        Statistics.startCompileTimer();
        ParserWrapper parser = ParserFactory.createParser(parsePyDML);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        DMLScript.initHadoopExecution(dmlconf);
        dmlt.rewriteHopsDAG(prog);
        if (dmlconf.getBooleanValue("codegen.enabled")) {
            SpoofCompiler.PLAN_CACHE_POLICY = SpoofCompiler.PlanCachePolicy.get(dmlconf.getBooleanValue("codegen.plancache"), dmlconf.getIntValue("codegen.literals") == 2);
            SpoofCompiler.setExecTypeSpecificJavaCompiler();
            if (SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.HOPS) {
                dmlt.codgenHopsDAG(prog);
            }
        }
        dmlt.constructLops(prog);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"\n********************** LOPS DAG *******************");
            dmlt.printLops(prog);
            dmlt.resetLopsDAGVisitStatus(prog);
        }
        Program rtprog = prog.getRuntimeProgram(dmlconf);
        if (dmlconf.getBooleanValue("codegen.enabled") && SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.RUNTIME) {
            dmlt.codgenHopsDAG(rtprog);
        }
        if (OptimizerUtils.isOptLevel(OptimizerUtils.OptimizationLevel.O4_GLOBAL_TIME_MEMORY)) {
            LOG.warn((Object)("Optimization level '" + (Object)((Object)OptimizerUtils.OptimizationLevel.O4_GLOBAL_TIME_MEMORY) + "' is still in experimental state and not intended for production use."));
            rtprog = GlobalOptimizerWrapper.optimizeProgram(prog, rtprog);
        }
        if (dmlconf.getBooleanValue("dml.yarn.appmaster")) {
            if (!DMLScript.isActiveAM() && DMLYarnClientProxy.launchDMLYarnAppmaster(dmlScriptStr, dmlconf, allArgs, rtprog)) {
                return;
            }
            if (DMLScript.isActiveAM()) {
                DMLAppMasterUtils.setupProgramMappingRemoteMaxMemory(rtprog);
            }
        }
        Explain.ExplainCounts counts = Explain.countDistributedOperations(rtprog);
        Statistics.resetNoOfCompiledJobs(counts.numJobs);
        if (EXPLAIN != Explain.ExplainType.NONE) {
            LOG.info((Object)("EXPLAIN (" + EXPLAIN.toString() + "):\n" + Explain.explainMemoryBudget(counts) + "\n" + Explain.explainDegreeOfParallelism(counts) + Explain.explain(prog, rtprog, EXPLAIN)));
        }
        Statistics.stopCompileTimer();
        GPUStatistics.DISPLAY_STATISTICS = dmlconf.getBooleanValue("systemml.stats.extraGPU");
        LibMatrixDNN.DISPLAY_STATISTICS = dmlconf.getBooleanValue("systemml.stats.extraDNN");
        Statistics.startRunTimer();
        ExecutionContext ec = null;
        try {
            ec = ExecutionContextFactory.createContext(rtprog);
            rtprog.execute(ec);
        }
        finally {
            if (USE_ACCELERATOR && ec != null) {
                ec.destroyGPUContext();
            }
            if (dmlconf.getBooleanValue("codegen.enabled")) {
                SpoofCompiler.cleanupCodeGenerator();
            }
            if (ec != null && ec instanceof SparkExecutionContext) {
                ((SparkExecutionContext)ec).close();
            }
            Statistics.stopRunTimer();
            LOG.info((Object)Statistics.display());
            LOG.info((Object)("END DML run " + DMLScript.getDateTime()));
            DMLScript.cleanupHadoopExecution(dmlconf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchDebugger(String dmlScriptStr, String fnameOptConfig, Map<String, String> argVals, boolean parsePyDML) throws ParseException, IOException, DMLRuntimeException, DMLDebuggerException, LanguageException, HopsException, LopsException {
        DMLDebuggerProgramInfo dbprog = new DMLDebuggerProgramInfo();
        DMLConfig conf = DMLConfig.readConfigurationFile(fnameOptConfig);
        ConfigurationManager.setGlobalConfig(conf);
        ParserWrapper parser = ParserFactory.createParser(parsePyDML);
        DMLProgram prog = parser.parse(DML_FILE_PATH_ANTLR_PARSER, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        dmlt.rewriteHopsDAG(prog);
        dmlt.constructLops(prog);
        dbprog.rtprog = prog.getRuntimeProgram(conf);
        try {
            DMLScript.initHadoopExecution(conf);
            DMLDebugger SystemMLdb = new DMLDebugger(dbprog, dmlScriptStr);
            SystemMLdb.runSystemMLDebugger();
        }
        finally {
            DMLScript.cleanupHadoopExecution(conf);
        }
    }

    public static void initHadoopExecution(DMLConfig config) throws IOException, ParseException, DMLRuntimeException {
        DMLScript.checkSecuritySetup(config);
        String scratch = config.getTextValue("scratch");
        MapReduceTool.createDirIfNotExistOnHDFS(scratch, "777");
        DMLScript.cleanupHadoopExecution(config);
        LocalFileUtils.createWorkingDirectory();
        CacheableData.initCaching();
        Statistics.resetNoOfExecutedJobs();
        if (STATISTICS) {
            CacheStatistics.reset();
            Statistics.reset();
        }
    }

    private static void checkSecuritySetup(DMLConfig config) throws IOException, DMLRuntimeException {
        String userName = System.getProperty("user.name");
        HashSet<String> groupNames = new HashSet<String>();
        try {
            if (UserGroupInformation.class.getMethod("getCurrentUser", new Class[0]) != null) {
                String[] groups = UserGroupInformation.getCurrentUser().getGroupNames();
                Collections.addAll(groupNames, groups);
            }
        }
        catch (Exception groups) {
            // empty catch block
        }
        JobConf job = ConfigurationManager.getCachedJobConf();
        boolean localMode = InfrastructureAnalyzer.isLocalMode(job);
        String taskController = job.get(MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER, "org.apache.hadoop.mapred.DefaultTaskController");
        String ttGroupName = job.get("mapreduce.tasktracker.group", "null");
        String perm = job.get(MRConfigurationNames.DFS_PERMISSIONS_ENABLED, "null");
        URI fsURI = FileSystem.getDefaultUri((Configuration)job);
        boolean flagDiffUser = !taskController.equals("org.apache.hadoop.mapred.LinuxTaskController") && !localMode && !groupNames.contains(ttGroupName);
        boolean flagLocalFS = fsURI == null || fsURI.getScheme().equals("file");
        boolean flagSecurity = perm.equals("yes");
        LOG.debug((Object)("SystemML security check: local.user.name = " + userName + ", local.user.groups = " + ProgramConverter.serializeStringCollection(groupNames) + ", " + MRConfigurationNames.MR_JOBTRACKER_ADDRESS + " = " + job.get(MRConfigurationNames.MR_JOBTRACKER_ADDRESS) + ", " + MRConfigurationNames.MR_TASKTRACKER_TASKCONTROLLER + " = " + taskController + "," + "mapreduce.tasktracker.group" + " = " + ttGroupName + ", " + MRConfigurationNames.FS_DEFAULTFS + " = " + (fsURI != null ? fsURI.getScheme() : "null") + ", " + MRConfigurationNames.DFS_PERMISSIONS_ENABLED + " = " + perm));
        if (flagDiffUser && (flagLocalFS || flagSecurity)) {
            LOG.warn((Object)("Cannot run map/reduce tasks as user '" + userName + "'. Using tasktracker group '" + ttGroupName + "'."));
        }
        String localtmpdir = config.getTextValue("localtmpdir");
        String hdfstmpdir = config.getTextValue("scratch");
        if (!LocalFileUtils.validateExternalFilename(localtmpdir, false)) {
            throw new DMLRuntimeException("Invalid (non-trustworthy) local working directory.");
        }
        if (!LocalFileUtils.validateExternalFilename(hdfstmpdir, true)) {
            throw new DMLRuntimeException("Invalid (non-trustworthy) hdfs working directory.");
        }
    }

    public static void cleanupHadoopExecution(DMLConfig config) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        String dirSuffix = sb.toString();
        MapReduceTool.deleteFileIfExistOnHDFS(config.getTextValue("scratch") + dirSuffix);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        if (InfrastructureAnalyzer.isLocalMode(job)) {
            try {
                LocalFileUtils.deleteFileIfExists(DMLConfig.LOCAL_MR_MODE_STAGING_DIR + dirSuffix);
                LocalFileUtils.deleteFileIfExists(MRJobConfiguration.getLocalWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getSystemWorkingDirPrefix(job) + dirSuffix);
                MapReduceTool.deleteFileIfExistOnHDFS(MRJobConfiguration.getStagingWorkingDirPrefix(job) + dirSuffix);
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to cleanup hadoop working dirs: " + ex.getMessage()));
            }
        }
        CacheableData.cleanupCacheDir();
        LocalFileUtils.cleanupWorkingDirectory();
    }

    private static void printInvocationInfo(String fnameScript, String fnameOptConfig, Map<String, String> argVals) {
        LOG.debug((Object)("****** args to DML Script ******\nUUID: " + DMLScript.getUUID() + "\nSCRIPT PATH: " + fnameScript + "\nRUNTIME: " + (Object)((Object)rtplatform) + "\nBUILTIN CONFIG: " + "./SystemML-config.xml" + "\nOPTIONAL CONFIG: " + fnameOptConfig + "\n"));
        if (!argVals.isEmpty()) {
            LOG.debug((Object)"Script arguments are: \n");
            for (int i = 1; i <= argVals.size(); ++i) {
                LOG.debug((Object)("Script argument $" + i + " = " + argVals.get("$" + i)));
            }
        }
    }

    private static void printStartExecInfo(String dmlScriptString) {
        LOG.info((Object)("BEGIN DML run " + DMLScript.getDateTime()));
        LOG.debug((Object)("DML script: \n" + dmlScriptString));
        if (rtplatform == RUNTIME_PLATFORM.HADOOP || rtplatform == RUNTIME_PLATFORM.HYBRID) {
            String hadoop_home = System.getenv("HADOOP_HOME");
            LOG.info((Object)("HADOOP_HOME: " + hadoop_home));
        }
    }

    private static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static void cleanSystemMLWorkspace() throws DMLException {
        try {
            String localtmp;
            DMLConfig conf = DMLConfig.readConfigurationFile(null);
            CleanupMR.runJob(conf);
            String scratch = conf.getTextValue("scratch");
            if (scratch != null) {
                MapReduceTool.deleteFileIfExistOnHDFS(scratch);
            }
            if ((localtmp = conf.getTextValue("localtmpdir")) != null) {
                LocalFileUtils.cleanupRcWorkingDirectory(localtmp);
            }
        }
        catch (Exception ex) {
            throw new DMLException("Failed to run SystemML workspace cleanup.", ex);
        }
    }

    public static enum RUNTIME_PLATFORM {
        HADOOP,
        SINGLE_NODE,
        HYBRID,
        HYBRID_SPARK,
        SPARK;

    }
}

