/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.transform.BinAgent;
import org.apache.sysml.runtime.transform.DummycodeAgent;
import org.apache.sysml.runtime.transform.MVImputeAgent;
import org.apache.sysml.runtime.transform.OmitAgent;
import org.apache.sysml.runtime.transform.RecodeAgent;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.encode.EncoderComposite;
import org.apache.sysml.runtime.transform.encode.EncoderPassThrough;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class EncoderFactory {
    public static Encoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta) throws DMLRuntimeException {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Expression.ValueType.STRING), meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Expression.ValueType[] schema, int clen, FrameBlock meta) throws DMLRuntimeException {
        Expression.ValueType[] lschema = schema == null ? UtilFunctions.nCopies(clen, Expression.ValueType.STRING) : schema;
        return EncoderFactory.createEncoder(spec, colnames, lschema, meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Expression.ValueType[] schema, FrameBlock meta) throws DMLRuntimeException {
        EncoderComposite encoder = null;
        int clen = schema.length;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Encoder> lencoders = new ArrayList<Encoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, "recode")));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, "dummycode")));
            rcIDs = new ArrayList<Integer>(CollectionUtils.union(rcIDs, dcIDs));
            List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(jSpec, colnames);
            ArrayList ptIDs = new ArrayList(CollectionUtils.subtract((Collection)CollectionUtils.subtract(UtilFunctions.getSequenceList(1, clen, 1), rcIDs), binIDs));
            List<Integer> oIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, "omit")));
            List<Integer> mvIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, "impute")));
            if (!rcIDs.isEmpty()) {
                RecodeAgent ra = new RecodeAgent(jSpec, colnames, clen);
                ra.setColList(ArrayUtils.toPrimitive((Integer[])rcIDs.toArray(new Integer[0])));
                lencoders.add(ra);
            }
            if (!ptIDs.isEmpty()) {
                lencoders.add(new EncoderPassThrough(ArrayUtils.toPrimitive((Integer[])ptIDs.toArray(new Integer[0])), clen));
            }
            if (!dcIDs.isEmpty()) {
                lencoders.add(new DummycodeAgent(jSpec, colnames, schema.length));
            }
            if (!binIDs.isEmpty()) {
                lencoders.add(new BinAgent(jSpec, colnames, schema.length, true));
            }
            if (!oIDs.isEmpty()) {
                lencoders.add(new OmitAgent(jSpec, colnames, schema.length));
            }
            if (!mvIDs.isEmpty()) {
                MVImputeAgent ma = new MVImputeAgent(jSpec, colnames, schema.length);
                ma.initRecodeIDList(rcIDs);
                lencoders.add(ma);
            }
            encoder = new EncoderComposite(lencoders);
            if (meta != null) {
                ((Encoder)encoder).initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return encoder;
    }
}

