/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;

public abstract class Encoder
implements Serializable {
    private static final long serialVersionUID = 2299156350718979064L;
    protected int _clen = -1;
    protected int[] _colList = null;

    protected Encoder(int[] colList, int clen) {
        this._colList = colList;
        this._clen = clen;
    }

    public int[] getColList() {
        return this._colList;
    }

    public void setColList(int[] colList) {
        this._colList = colList;
    }

    public int getNumCols() {
        return this._clen;
    }

    public int initColList(JSONArray attrs) {
        this._colList = new int[attrs.size()];
        for (int i = 0; i < this._colList.length; ++i) {
            this._colList[i] = UtilFunctions.toInt(attrs.get(i));
        }
        return this._colList.length;
    }

    public int initColList(int[] colList) {
        this._colList = colList;
        return this._colList.length;
    }

    public boolean isApplicable() {
        return this._colList != null && this._colList.length > 0;
    }

    public int isApplicable(int colID) {
        if (this._colList == null) {
            return -1;
        }
        int idx = Arrays.binarySearch(this._colList, colID);
        return idx >= 0 ? idx : -1;
    }

    public abstract MatrixBlock encode(FrameBlock var1, MatrixBlock var2);

    public abstract void build(FrameBlock var1);

    public abstract MatrixBlock apply(FrameBlock var1, MatrixBlock var2);

    public abstract String[] apply(String[] var1);

    public abstract FrameBlock getMetaData(FrameBlock var1);

    public abstract void initMetaData(FrameBlock var1);

    public abstract void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> var1, int var2, TfUtils var3) throws IOException;

    public abstract void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> var1, String var2, int var3, FileSystem var4, TfUtils var5) throws IOException;

    public abstract void loadTxMtd(JobConf var1, FileSystem var2, Path var3, TfUtils var4) throws IOException;
}

