/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.decode;

import java.util.HashMap;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.transform.decode.Decoder;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DecoderRecode
extends Decoder {
    private static final long serialVersionUID = -3784249774608228805L;
    private HashMap<Long, Object>[] _rcMaps = null;
    private boolean _onOut = false;

    protected DecoderRecode(Expression.ValueType[] schema, boolean onOut, int[] rcCols) {
        super(schema, rcCols);
        this._onOut = onOut;
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        if (this._onOut) {
            for (int i = 0; i < in.getNumRows(); ++i) {
                for (int j = 0; j < this._colList.length; ++j) {
                    int colID = this._colList[j];
                    double val = UtilFunctions.objectToDouble(out.getSchema()[colID - 1], out.get(i, colID - 1));
                    long key = UtilFunctions.toLong(val);
                    out.set(i, colID - 1, this._rcMaps[j].get(key));
                }
            }
        } else {
            out.ensureAllocatedColumns(in.getNumRows());
            for (int i = 0; i < in.getNumRows(); ++i) {
                for (int j = 0; j < this._colList.length; ++j) {
                    double val = in.quickGetValue(i, this._colList[j] - 1);
                    long key = UtilFunctions.toLong(val);
                    out.set(i, this._colList[j] - 1, this._rcMaps[j].get(key));
                }
            }
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._rcMaps = new HashMap[this._colList.length];
        for (int j = 0; j < this._colList.length; ++j) {
            HashMap<Long, Object> map = new HashMap<Long, Object>();
            for (int i = 0; i < meta.getNumRows() && meta.get(i, this._colList[j] - 1) != null; ++i) {
                String[] tmp = meta.get(i, this._colList[j] - 1).toString().split("\u00b7");
                Object obj = UtilFunctions.stringToObject(this._schema[this._colList[j] - 1], tmp[0]);
                map.put(Long.parseLong(tmp[1]), obj);
            }
            this._rcMaps[j] = map;
        }
    }

    public static void parseRecodeMapEntry(String entry, Pair<String, String> pair) {
        int ixq = entry.lastIndexOf(34);
        String token = UtilFunctions.unquote(entry.substring(0, ixq + 1));
        int idx = ixq + 2;
        while (entry.charAt(idx) != ",".charAt(0)) {
            ++idx;
        }
        String id = entry.substring(ixq + 2, idx);
        pair.set(token, id);
    }
}

