/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;

public class GTFMTDReducer
implements Reducer<IntWritable, DistinctValue, Text, LongWritable> {
    private JobConf _rJob = null;
    TfUtils _agents = null;

    public void configure(JobConf job) {
        this._rJob = job;
        try {
            String outputDir = MRJobConfiguration.getOutputs(job)[0];
            this._agents = new TfUtils(job, outputDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    public void reduce(IntWritable key, Iterator<DistinctValue> values, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this._rJob);
        int colID = key.get();
        if (colID < 0) {
            this._agents.getMVImputeAgent().mergeAndOutputTransformationMetadata(values, this._agents.getTfMtdDir(), colID *= -1, fs, this._agents);
        } else if ((long)colID == this._agents.getNumCols() + 1L) {
            ArrayList<CSVReblockMR.OffsetCount> list = new ArrayList<CSVReblockMR.OffsetCount>();
            while (values.hasNext()) {
                list.add(new CSVReblockMR.OffsetCount(values.next().getOffsetCount()));
            }
            long numTfRows = this.generateOffsetsFile(list);
            reporter.incrCounter((Enum)MRJobConfiguration.DataTransformCounters.TRANSFORMED_NUM_ROWS, numTfRows);
        } else {
            this._agents.getRecodeAgent().mergeAndOutputTransformationMetadata(values, this._agents.getTfMtdDir(), colID, fs, this._agents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateOffsetsFile(ArrayList<CSVReblockMR.OffsetCount> list) throws IllegalArgumentException, IOException {
        Collections.sort(list);
        SequenceFile.Writer writer = null;
        long lineOffset = 0L;
        try {
            writer = new SequenceFile.Writer(FileSystem.get((Configuration)this._rJob), (Configuration)this._rJob, new Path(this._agents.getOffsetFile() + "/part-00000"), ByteWritable.class, CSVReblockMR.OffsetCount.class);
            for (CSVReblockMR.OffsetCount oc : list) {
                long count = oc.count;
                oc.count = lineOffset;
                writer.append((Writable)new ByteWritable(0), (Writable)oc);
                lineOffset += count;
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
        list.clear();
        return lineOffset;
    }
}

