/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;

public class GTFMTDMapper
implements Mapper<LongWritable, Text, IntWritable, DistinctValue> {
    private OutputCollector<IntWritable, DistinctValue> _collector = null;
    private int _mapTaskID = -1;
    TfUtils _agents = null;
    private boolean _partFileWithHeader = false;
    private boolean _firstRecordInSplit = true;
    private String _partFileName = null;
    private long _offsetInPartFile = -1L;

    public void configure(JobConf job) {
        String[] parts = job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID).split("_");
        if (parts[0].equalsIgnoreCase("task")) {
            this._mapTaskID = Integer.parseInt(parts[parts.length - 1]);
        } else if (parts[0].equalsIgnoreCase("attempt")) {
            this._mapTaskID = Integer.parseInt(parts[parts.length - 2]);
        } else {
            throw new RuntimeException("Unrecognized format for taskID: " + job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID));
        }
        try {
            this._partFileName = TfUtils.getPartFileName(job);
            this._partFileWithHeader = TfUtils.isPartFileWithHeader(job);
            this._agents = new TfUtils(job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void map(LongWritable rawKey, Text rawValue, OutputCollector<IntWritable, DistinctValue> out, Reporter reporter) throws IOException {
        if (this._firstRecordInSplit) {
            this._firstRecordInSplit = false;
            this._collector = out;
            this._offsetInPartFile = rawKey.get();
        }
        if (this._agents.hasHeader() && rawKey.get() == 0L && this._partFileWithHeader) {
            return;
        }
        this._agents.prepareTfMtd(rawValue.toString());
    }

    public void close() throws IOException {
        this._agents.getMVImputeAgent().mapOutputTransformationMetadata(this._collector, this._mapTaskID, this._agents);
        this._agents.getRecodeAgent().mapOutputTransformationMetadata(this._collector, this._mapTaskID, this._agents);
        this._agents.getBinAgent().mapOutputTransformationMetadata(this._collector, this._mapTaskID, this._agents);
        if (this._collector != null) {
            IntWritable key = new IntWritable((int)this._agents.getNumCols() + 1);
            DistinctValue val = new DistinctValue(new CSVReblockMR.OffsetCount(this._partFileName, this._offsetInPartFile, this._agents.getValid()));
            this._collector.collect((Object)key, (Object)val);
        }
        this._firstRecordInSplit = true;
        this._offsetInPartFile = -1L;
        this._partFileWithHeader = false;
    }
}

