/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class DummycodeAgent
extends Encoder {
    private static final long serialVersionUID = 5832130477659116489L;
    private HashMap<Integer, HashMap<String, String>> _finalMaps = null;
    private HashMap<Integer, HashMap<String, Long>> _finalMapsCP = null;
    private int[] _binList = null;
    private int[] _numBins = null;
    private int[] _domainSizes = null;
    private int[] _dcdColumnMap = null;
    private long _dummycodedLength = 0L;

    public DummycodeAgent(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        if (parsedSpec.containsKey("dummycode")) {
            int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "dummycode");
            this.initColList(collist);
        }
    }

    @Override
    public int getNumCols() {
        return (int)this._dummycodedLength;
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
    }

    public void setRecodeMaps(HashMap<Integer, HashMap<String, String>> maps) {
        this._finalMaps = maps;
    }

    public void setRecodeMapsCP(HashMap<Integer, HashMap<String, Long>> maps) {
        this._finalMapsCP = maps;
    }

    public void setNumBins(int[] binList, int[] numbins) {
        this._binList = binList;
        this._numBins = numbins;
    }

    public int genDcdMapsAndColTypes(FileSystem fs, String txMtdDir, int numCols, TfUtils agents) throws IOException {
        TfUtils.ColumnTypes[] ctypes = new TfUtils.ColumnTypes[(int)this._dummycodedLength];
        int i = 0;
        while ((long)i < this._dummycodedLength) {
            ctypes[i] = TfUtils.ColumnTypes.SCALE;
            ++i;
        }
        this._dcdColumnMap = new int[numCols];
        int sum = 1;
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(txMtdDir + "/Dummycode/" + "dummyCodeMaps.csv"), true)));){
            int idx = 0;
            for (int colID = 1; colID <= numCols; ++colID) {
                if (this._colList != null && idx < this._colList.length && this._colList[idx] == colID) {
                    br.write(colID + "," + "1" + "," + sum + "," + (sum + this._domainSizes[idx] - 1) + "\n");
                    this._dcdColumnMap[colID - 1] = sum + this._domainSizes[idx] - 1 - 1;
                    for (int i2 = sum; i2 <= sum + this._domainSizes[idx] - 1; ++i2) {
                        ctypes[i2 - 1] = TfUtils.ColumnTypes.DUMMYCODED;
                    }
                    sum += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                br.write(colID + "," + "0" + "," + sum + "," + sum + "\n");
                this._dcdColumnMap[colID - 1] = sum - 1;
                if (agents.getBinAgent().isApplicable(colID) != -1) {
                    ctypes[sum - 1] = TfUtils.ColumnTypes.ORDINAL;
                }
                if (agents.getRecodeAgent().isApplicable(colID) != -1) {
                    ctypes[sum - 1] = TfUtils.ColumnTypes.NOMINAL;
                }
                ++sum;
            }
        }
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(txMtdDir + File.separator + "coltypes.csv"), true)));
        var8_8 = null;
        try {
            br.write(ctypes[0].toID() + "");
            int i3 = 1;
            while ((long)i3 < this._dummycodedLength) {
                br.write("," + ctypes[i3].toID());
                ++i3;
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        return sum - 1;
    }

    public int mapDcdColumnID(int colID) {
        for (int i = 0; i < this._dcdColumnMap.length; ++i) {
            int st = i == 0 ? 1 : this._dcdColumnMap[i - 1] + 1 + 1;
            int end = this._dcdColumnMap[i] + 1;
            if (colID < st || colID > end) continue;
            return i + 1;
        }
        return -1;
    }

    public String constructDummycodedHeader(String header, Pattern delim) {
        int idx;
        Comparator<Map.Entry<String, Object>> comp;
        ArrayList<Map.Entry<String, Object>> entryList;
        String colName;
        HashMap<String, Object> map;
        int colID;
        int i;
        if (this._colList == null && this._binList == null) {
            return header;
        }
        String[] names = delim.split(header, -1);
        ArrayList newNames = null;
        StringBuilder sb = new StringBuilder();
        if (this._finalMapsCP != null && this._colList != null) {
            for (i = 0; i < this._colList.length; ++i) {
                colID = this._colList[i];
                map = this._finalMapsCP.get(colID);
                colName = UtilFunctions.unquote(names[colID - 1]);
                if (map == null) continue;
                entryList = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
                comp = new Comparator<Map.Entry<String, Long>>(){

                    @Override
                    public int compare(Map.Entry<String, Long> entry1, Map.Entry<String, Long> entry2) {
                        Long value1 = entry1.getValue();
                        Long value2 = entry2.getValue();
                        return (int)(value1 - value2);
                    }
                };
                Collections.sort(entryList, comp);
                newNames = new ArrayList();
                for (Map.Entry entry : entryList) {
                    newNames.add(entry.getKey());
                }
                sb.setLength(0);
                for (idx = 0; idx < newNames.size(); ++idx) {
                    if (idx == 0) {
                        sb.append(colName + "_" + (String)newNames.get(idx));
                        continue;
                    }
                    sb.append(delim + colName + "_" + (String)newNames.get(idx));
                }
                names[colID - 1] = sb.toString();
            }
        } else if (this._finalMaps != null && this._colList != null) {
            for (i = 0; i < this._colList.length; ++i) {
                colID = this._colList[i];
                map = this._finalMaps.get(colID);
                colName = UtilFunctions.unquote(names[colID - 1]);
                if (map == null) continue;
                entryList = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
                comp = new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> entry1, Map.Entry<String, String> entry2) {
                        String value1 = entry1.getValue();
                        String value2 = entry2.getValue();
                        return Integer.parseInt(value1) - Integer.parseInt(value2);
                    }
                };
                Collections.sort(entryList, comp);
                newNames = new ArrayList();
                for (Map.Entry entry : entryList) {
                    newNames.add(entry.getKey());
                }
                sb.setLength(0);
                for (idx = 0; idx < newNames.size(); ++idx) {
                    if (idx == 0) {
                        sb.append(colName + "_" + (String)newNames.get(idx));
                        continue;
                    }
                    sb.append(delim + colName + "_" + (String)newNames.get(idx));
                }
                names[colID - 1] = sb.toString();
            }
        }
        if (this._binList != null) {
            for (i = 0; i < this._binList.length; ++i) {
                colID = this._binList[i];
                if (this.isApplicable(colID) == -1) continue;
                int numBins = this._numBins[i];
                colName = UtilFunctions.unquote(names[colID - 1]);
                sb.setLength(0);
                for (int idx2 = 0; idx2 < numBins; ++idx2) {
                    if (idx2 == 0) {
                        sb.append(colName + "_" + "Bin" + (idx2 + 1));
                        continue;
                    }
                    sb.append(delim + colName + "_" + "Bin" + (idx2 + 1));
                }
                names[colID - 1] = sb.toString();
            }
        }
        sb.setLength(0);
        for (int colID2 = 0; colID2 < names.length; ++colID2) {
            if (colID2 == 0) {
                sb.append(names[colID2]);
                continue;
            }
            sb.append(delim + names[colID2]);
        }
        return sb.toString();
    }

    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        if (!this.isApplicable()) {
            this._dummycodedLength = this._clen;
            return;
        }
        Arrays.sort(this._colList);
        this._domainSizes = new int[this._colList.length];
        this._dummycodedLength = this._clen;
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            int domainSize = 0;
            if (this._finalMaps != null) {
                if (this._finalMaps.get(colID) != null) {
                    domainSize = this._finalMaps.get(colID).size();
                }
            } else if (this._finalMapsCP.get(colID) != null) {
                domainSize = this._finalMapsCP.get(colID).size();
            }
            if (domainSize != 0) {
                this._domainSizes[i] = domainSize;
            } else if (this._binList != null) {
                for (int j = 0; j < this._binList.length; ++j) {
                    if (colID != this._binList[j]) continue;
                    this._domainSizes[i] = this._numBins[j];
                    break;
                }
            }
            this._dummycodedLength += (long)(this._domainSizes[i] - 1);
        }
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public String[] apply(String[] words) {
        if (!this.isApplicable()) {
            return words;
        }
        String[] nwords = new String[(int)this._dummycodedLength];
        int rcdVal = 0;
        int idx = 0;
        int ncolID = 1;
        for (int colID = 1; colID <= words.length; ++colID) {
            if (idx < this._colList.length && colID == this._colList[idx]) {
                try {
                    rcdVal = UtilFunctions.parseToInt(UtilFunctions.unquote(words[colID - 1]));
                    nwords[ncolID - 1 + rcdVal - 1] = "1";
                    ncolID += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in dummycoding: colID=" + colID + ", rcdVal=" + rcdVal + ", word=" + words[colID - 1] + ", domainSize=" + this._domainSizes[idx] + ", dummyCodedLength=" + this._dummycodedLength);
                }
            }
            nwords[ncolID - 1] = words[colID - 1];
            ++ncolID;
        }
        return nwords;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        MatrixBlock ret = new MatrixBlock(out.getNumRows(), (int)this._dummycodedLength, false);
        for (int i = 0; i < out.getNumRows(); ++i) {
            int idx = 0;
            int ncolID = 1;
            for (int colID = 1; colID <= out.getNumColumns(); ++colID) {
                double val = out.quickGetValue(i, colID - 1);
                if (idx < this._colList.length && colID == this._colList[idx]) {
                    ret.quickSetValue(i, ncolID - 1 + (int)val - 1, 1.0);
                    ncolID += this._domainSizes[idx];
                    ++idx;
                    continue;
                }
                double ptval = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                ret.quickSetValue(i, ncolID - 1, ptval);
                ++ncolID;
            }
        }
        return ret;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSizes = new int[this._colList.length];
        this._dummycodedLength = this._clen;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._domainSizes[j] = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._dummycodedLength += (long)(this._domainSizes[j] - 1);
        }
    }
}

