/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import scala.Tuple2;

public class ApplyTfCSVSPARK {
    public static JavaPairRDD<Long, String> runSparkJob(SparkExecutionContext sec, JavaRDD<Tuple2<LongWritable, Text>> inputRDD, String tfMtdPath, String spec, String tmpPath, CSVFileFormatProperties prop, int numCols, String headerLine) throws IOException, ClassNotFoundException, InterruptedException, IllegalArgumentException, JSONException {
        String[] naStrings = TfUtils.parseNAStrings(prop.getNAStrings());
        JSONObject jspec = new JSONObject(spec);
        TfUtils _tfmapper = new TfUtils(headerLine, prop.hasHeader(), prop.getDelim(), naStrings, jspec, numCols, tfMtdPath, null, tmpPath);
        _tfmapper.loadTfMetadata();
        Broadcast bcast_tf = sec.getSparkContext().broadcast((Object)_tfmapper);
        JavaPairRDD applyRDD = inputRDD.mapPartitionsWithIndex((Function2)new ApplyTfCSVMap((Broadcast<TfUtils>)bcast_tf), true).mapToPair((PairFunction)new PairFunction<String, Long, String>(){
            private static final long serialVersionUID = 3868143093999082931L;

            public Tuple2<Long, String> call(String t) throws Exception {
                return new Tuple2((Object)new Long(1L), (Object)t);
            }
        }).cache();
        applyRDD.count();
        return applyRDD;
    }

    public static class ApplyTfCSVMap
    implements Function2<Integer, Iterator<Tuple2<LongWritable, Text>>, Iterator<String>> {
        private static final long serialVersionUID = 1496686437276906911L;
        TfUtils _tfmapper = null;

        ApplyTfCSVMap(Broadcast<TfUtils> tf) throws IllegalArgumentException, IOException, JSONException {
            this._tfmapper = (TfUtils)tf.getValue();
        }

        public Iterator<String> call(Integer partitionID, Iterator<Tuple2<LongWritable, Text>> csvLines) throws Exception {
            boolean first = true;
            Tuple2<LongWritable, Text> rec = null;
            ArrayList<String> outLines = new ArrayList<String>();
            while (csvLines.hasNext()) {
                String[] words;
                rec = csvLines.next();
                if (first && partitionID == 0) {
                    first = false;
                    this._tfmapper.processHeaderLine();
                    if (this._tfmapper.hasHeader()) continue;
                }
                if (this._tfmapper.omit(words = this._tfmapper.getWords((Text)rec._2()))) continue;
                try {
                    words = this._tfmapper.apply(words);
                    String outStr = this._tfmapper.checkAndPrepOutputString(words);
                    outLines.add(outStr);
                }
                catch (DMLRuntimeException e) {
                    throw new RuntimeException(e.getMessage() + ": " + ((Text)rec._2()).toString());
                }
            }
            return outLines.iterator();
        }
    }
}

