/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.wink.json4j.JSONException;

public class ApplyTfCSVMapper
implements Mapper<LongWritable, Text, NullWritable, Text> {
    boolean _firstRecordInSplit = true;
    boolean _partFileWithHeader = false;
    TfUtils tfmapper = null;
    Reporter _reporter = null;
    BufferedWriter br = null;
    JobConf _rJob = null;

    public void configure(JobConf job) {
        try {
            this._rJob = job;
            this._partFileWithHeader = TfUtils.isPartFileWithHeader(job);
            this.tfmapper = new TfUtils(job);
            this.tfmapper.loadTfMetadata(job, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void map(LongWritable rawKey, Text rawValue, OutputCollector<NullWritable, Text> out, Reporter reporter) throws IOException {
        String[] words;
        if (this._firstRecordInSplit) {
            this._firstRecordInSplit = false;
            this._reporter = reporter;
            String partFileSuffix = this.tfmapper.getPartFileID(this._rJob, rawKey.get());
            Path mapOutputPath = new Path(this.tfmapper.getOutputPath() + "/transform-part-" + partFileSuffix);
            this.br = new BufferedWriter(new OutputStreamWriter((OutputStream)FileSystem.get((Configuration)this._rJob).create(mapOutputPath, true)));
        }
        if (rawKey.get() == 0L && this._partFileWithHeader) {
            this._reporter = reporter;
            this.tfmapper.processHeaderLine();
            if (this.tfmapper.hasHeader()) {
                return;
            }
        }
        if (!this.tfmapper.omit(words = this.tfmapper.getWords(rawValue))) {
            try {
                words = this.tfmapper.apply(words);
                String outStr = this.tfmapper.checkAndPrepOutputString(words);
                this.br.write(outStr + "\n");
            }
            catch (DMLRuntimeException e) {
                throw new RuntimeException(e.getMessage() + ": " + rawValue.toString());
            }
        }
    }

    public void close() throws IOException {
        IOUtilFunctions.closeSilently(this.br);
    }
}

