/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.transform.ApplyTfCSVMapper;
import org.apache.sysml.runtime.transform.TfUtils;

public class ApplyTfCSVMR {
    public static JobReturn runJob(String inputPath, String spec, String mapsPath, String tmpPath, String outputPath, String partOffsetsFile, CSVFileFormatProperties inputDataProperties, long numCols, int replication, String headerLine) throws IOException, ClassNotFoundException, InterruptedException {
        JobConf job = new JobConf(ApplyTfCSVMR.class);
        job.setJobName("ApplyTfCSV");
        job.setJarByClass(ApplyTfCSVMR.class);
        job.setMapperClass(ApplyTfCSVMapper.class);
        job.setNumReduceTasks(0);
        DistributedCache.addCacheFile((URI)new Path(mapsPath).toUri(), (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        Path cachefile = new Path(partOffsetsFile);
        DistributedCache.addCacheFile((URI)cachefile.toUri(), (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        job.setInputFormat(TextInputFormat.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        job.setInt("dfs.replication", replication);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(inputPath));
        Path outPath = new Path(outputPath);
        FileSystem fs = FileSystem.get((Configuration)job);
        fs.delete(outPath, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outPath);
        job.set("transform.has.header", Boolean.toString(inputDataProperties.hasHeader()));
        job.set("transform.field.delimiter", inputDataProperties.getDelim());
        if (inputDataProperties.getNAStrings() != null) {
            job.set("transform.na.strings", TfUtils.prepNAStrings(inputDataProperties.getNAStrings()));
        }
        job.set("transform.specification", spec);
        job.set("transform.smallest.file", CSVReblockMR.findSmallestFile(job, inputPath));
        job.set("output.matrices.dirs", outputPath);
        job.setLong("transform.num.columns", numCols);
        job.set("transform.txmtd.path", mapsPath);
        job.set("transform.header.line", headerLine);
        job.set("rowid.file.name", cachefile.toString());
        job.set("transform.temp.location", tmpPath);
        job.setBoolean("adaptivemr.map.enable", false);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        ApplyTfCSVMR.deletePartFiles(fs, outPath);
        MatrixCharacteristics mc = new MatrixCharacteristics();
        return new JobReturn(new MatrixCharacteristics[]{mc}, runjob.isSuccessful());
    }

    private static void deletePartFiles(FileSystem fs, Path path) throws FileNotFoundException, IOException {
        FileStatus[] list;
        PathFilter filter = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().startsWith("part-");
            }
        };
        for (FileStatus stat : list = fs.listStatus(path, filter)) {
            fs.delete(stat.getPath(), false);
        }
    }
}

