/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseRow;

public class SparseBlockMCSR
extends SparseBlock {
    private static final long serialVersionUID = -4743624499258436199L;
    private SparseRow[] _rows = null;

    public SparseBlockMCSR(SparseBlock sblock) {
        if (sblock instanceof SparseBlockMCSR) {
            SparseRow[] orows = ((SparseBlockMCSR)sblock)._rows;
            this._rows = new SparseRow[orows.length];
            for (int i = 0; i < this._rows.length; ++i) {
                this._rows[i] = new SparseRow(orows[i]);
            }
        } else {
            this._rows = new SparseRow[sblock.numRows()];
            for (int i = 0; i < this._rows.length; ++i) {
                if (sblock.isEmpty(i)) continue;
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                this._rows[i] = new SparseRow(alen);
                this._rows[i].setSize(alen);
                System.arraycopy(sblock.indexes(i), apos, this._rows[i].indexes(), 0, alen);
                System.arraycopy(sblock.values(i), apos, this._rows[i].values(), 0, alen);
            }
        }
    }

    public SparseBlockMCSR(SparseRow[] rows, boolean deep) {
        if (deep) {
            this._rows = new SparseRow[rows.length];
            for (int i = 0; i < this._rows.length; ++i) {
                this._rows[i] = new SparseRow(rows[i]);
            }
        } else {
            this._rows = rows;
        }
    }

    public SparseBlockMCSR(int rlen, int clen) {
        this._rows = new SparseRow[rlen];
    }

    public static long estimateMemory(long nrows, long ncols, double sparsity) {
        double cnnz = Math.max(4.0, Math.ceil(sparsity * (double)ncols));
        double rlen = Math.min((double)nrows, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 16.0;
        size += rlen * (116.0 + cnnz * 12.0);
        return (long)Math.min(size += 32.0 + (double)nrows * 8.0, 9.223372036854776E18);
    }

    @Override
    public void allocate(int r) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow();
        }
    }

    @Override
    public void allocate(int r, int nnz) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow(nnz);
        }
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow(ennz, maxnnz);
        }
    }

    @Override
    public int numRows() {
        return this._rows.length;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public void reset() {
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            row.reset(row.size(), Integer.MAX_VALUE);
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            row.reset(ennz, maxnnz);
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        if (this._rows[r] != null) {
            this._rows[r].reset(ennz, maxnnz);
        }
    }

    @Override
    public long size() {
        long nnz = 0L;
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            nnz += (long)row.size();
        }
        return nnz;
    }

    @Override
    public int size(int r) {
        return this._rows[r] != null ? this._rows[r].size() : 0;
    }

    @Override
    public long size(int rl, int ru) {
        int ret = 0;
        for (int i = rl; i < ru; ++i) {
            ret += this._rows[i] != null ? this._rows[i].size() : 0;
        }
        return ret;
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = rl; i < ru; ++i) {
            if (this.isEmpty(i)) continue;
            int start = this.posFIndexGTE(i, cl);
            int end = this.posFIndexGTE(i, cu);
            nnz += start != -1 ? (long)(end - start) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        return this._rows[r] == null || this._rows[r].isEmpty();
    }

    @Override
    public int[] indexes(int r) {
        return this._rows[r].indexes();
    }

    @Override
    public double[] values(int r) {
        return this._rows[r].values();
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    @Override
    public boolean set(int r, int c, double v) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow();
        }
        return this._rows[r].set(c, v);
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        if (this._rows[r] != null && this._rows[r].capacity() >= row.size() && deep) {
            this._rows[r].copy(row);
        } else {
            this._rows[r] = deep && row != null ? new SparseRow(row) : row;
        }
    }

    @Override
    public void append(int r, int c, double v) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow();
        }
        this._rows[r].append(c, v);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int len) {
        if (this._rows[r] == null) {
            this._rows[r] = new SparseRow();
        }
        this._rows[r].setIndexRange(cl, cu - 1, v, vix, len);
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        this._rows[r].deleteIndexRange(cl, cu - 1);
    }

    @Override
    public void sort() {
        for (SparseRow row : this._rows) {
            if (row == null || row.isEmpty()) continue;
            row.sort();
        }
    }

    @Override
    public void sort(int r) {
        this._rows[r].sort();
    }

    @Override
    public double get(int r, int c) {
        if (this._rows[r] == null) {
            return 0.0;
        }
        return this._rows[r].get(c);
    }

    @Override
    public SparseRow get(int r) {
        return this._rows[r];
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        return this._rows[r].searchIndexesFirstLTE(c);
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        return this._rows[r].searchIndexesFirstGTE(c);
    }

    @Override
    public int posFIndexGT(int r, int c) {
        return this._rows[r].searchIndexesFirstGT(c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockMCSR: rlen=");
        sb.append(this.numRows());
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        for (int i = 0; i < this.numRows(); ++i) {
            sb.append("row +");
            sb.append(i);
            sb.append(": ");
            sb.append(this._rows[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public SparseRow[] getRows() {
        return this._rows;
    }
}

