/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.util.NormalPRNGenerator;
import org.apache.sysml.runtime.util.PRNGenerator;
import org.apache.sysml.runtime.util.PoissonPRNGenerator;
import org.apache.sysml.runtime.util.UniformPRNGenerator;

public class RandomMatrixGenerator {
    String _pdf;
    int _rows;
    int _cols;
    int _rowsPerBlock;
    int _colsPerBlock;
    double _sparsity;
    double _mean;
    double _min;
    double _max;
    PRNGenerator _valuePRNG;

    public RandomMatrixGenerator() {
        this._pdf = "";
        this._colsPerBlock = -1;
        this._rowsPerBlock = -1;
        this._cols = -1;
        this._rows = -1;
        this._sparsity = 0.0;
        this._max = Double.NaN;
        this._min = Double.NaN;
        this._valuePRNG = null;
        this._mean = 1.0;
    }

    public RandomMatrixGenerator(String pdf, int r, int c, int rpb, int cpb, double sp) throws DMLRuntimeException {
        this(pdf, r, c, rpb, cpb, sp, Double.NaN, Double.NaN);
    }

    public RandomMatrixGenerator(String pdf, int r, int c, int rpb, int cpb, double sp, double min, double max) throws DMLRuntimeException {
        this.init(pdf, r, c, rpb, cpb, sp, min, max);
    }

    public void init(String pdf, int r, int c, int rpb, int cpb, double sp, double min, double max) throws DMLRuntimeException {
        this._pdf = pdf;
        this._rows = r;
        this._cols = c;
        this._rowsPerBlock = rpb;
        this._colsPerBlock = cpb;
        this._sparsity = sp;
        this._min = min;
        this._max = max;
        this.setupValuePRNG();
    }

    public RandomMatrixGenerator(String pdf, int r, int c, int rpb, int cpb, double sp, double min, double max, double mean) throws DMLRuntimeException {
        this.init(pdf, r, c, rpb, cpb, sp, min, max, mean);
    }

    public void init(String pdf, int r, int c, int rpb, int cpb, double sp, double min, double max, double mean) throws DMLRuntimeException {
        this._pdf = pdf;
        this._rows = r;
        this._cols = c;
        this._rowsPerBlock = rpb;
        this._colsPerBlock = cpb;
        this._sparsity = sp;
        this._min = min;
        this._max = max;
        this._mean = mean;
        this.setupValuePRNG();
    }

    protected void setupValuePRNG() throws DMLRuntimeException {
        if (this._pdf.equalsIgnoreCase("normal")) {
            this._valuePRNG = new NormalPRNGenerator();
        } else if (this._pdf.equalsIgnoreCase("uniform")) {
            this._valuePRNG = new UniformPRNGenerator();
        } else if (this._pdf.equalsIgnoreCase("poisson")) {
            if (this._mean <= 0.0) {
                throw new DMLRuntimeException("Invalid parameter (" + this._mean + ") for Poisson distribution.");
            }
            this._valuePRNG = new PoissonPRNGenerator(this._mean);
        }
    }
}

