/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.ConvolutionUtils;

public class ConvolutionParameters
implements Serializable {
    private static final long serialVersionUID = -212362627205772829L;
    public int N;
    public int C;
    public int H;
    public int W;
    public int K;
    public int R;
    public int S;
    public int stride_h;
    public int stride_w;
    public int pad_h;
    public int pad_w;
    public int P;
    public int Q;
    public int numThreads;
    MatrixBlock input1;
    MatrixBlock input2;
    MatrixBlock output;
    public MatrixBlock bias;
    public int[] start_indexes_h;
    public int[] end_indexes_h;
    public int[] start_indexes_w;
    public int[] end_indexes_w;

    private int convertToInt(long val) throws DMLRuntimeException {
        if (val > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("The value for ConvolutionParameters is too large:" + val);
        }
        return (int)val;
    }

    public boolean compare(ConvolutionParameters that) {
        return this.N == that.N && this.C == that.C && this.H == that.H && this.W == that.W && this.K == that.K && this.R == that.R && this.S == that.S && this.stride_h == that.stride_h && this.stride_w == that.stride_w && this.pad_h == that.pad_h && this.pad_w == that.pad_w && this.numThreads == that.numThreads;
    }

    public String toString() {
        return "(" + this.N + " " + this.C + " " + this.H + " " + this.W + " " + this.K + " " + this.R + " " + this.S + ")";
    }

    public ConvolutionParameters(long N, long C, long H, long W, long K, long R, long S, long stride_h, long stride_w, long pad_h, long pad_w, int numThreads) throws DMLRuntimeException {
        this.N = this.convertToInt(N);
        this.C = this.convertToInt(C);
        this.H = this.convertToInt(H);
        this.W = this.convertToInt(W);
        this.K = this.convertToInt(K);
        this.R = this.convertToInt(R);
        this.S = this.convertToInt(S);
        this.stride_h = this.convertToInt(stride_h);
        this.stride_w = this.convertToInt(stride_w);
        this.pad_h = this.convertToInt(pad_h);
        this.pad_w = this.convertToInt(pad_w);
        this.P = H >= 0L && pad_h >= 0L && R >= 0L && stride_h >= 0L ? (int)((H + 2L * pad_h - R) / stride_h + 1L) : -1;
        this.Q = W >= 0L && pad_w >= 0L && S >= 0L && stride_w >= 0L ? (int)((W + 2L * pad_w - S) / stride_w + 1L) : -1;
        this.numThreads = numThreads;
    }

    public ConvolutionParameters(int N, int C, int H, int W, int K, int R, int S, int stride_h, int stride_w, int pad_h, int pad_w, int numThreads) {
        this.N = N;
        this.C = C;
        this.H = H;
        this.W = W;
        this.K = K;
        this.R = R;
        this.S = S;
        this.stride_h = stride_h;
        this.stride_w = stride_w;
        this.pad_h = pad_h;
        this.pad_w = pad_w;
        this.P = (int)ConvolutionUtils.getP(H, R, stride_h, pad_h);
        this.Q = (int)ConvolutionUtils.getQ(W, S, stride_w, pad_w);
        this.numThreads = numThreads;
    }

    public boolean isOutputThreadSafe() {
        return this.output.isThreadSafe();
    }
}

