/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.ArrayList;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.LongLongDoubleHashMap;

public class CTableMap {
    private LongLongDoubleHashMap _map = new LongLongDoubleHashMap();
    private long _maxRow = -1L;
    private long _maxCol = -1L;

    public int size() {
        return this._map.size();
    }

    @Deprecated
    public ArrayList<LongLongDoubleHashMap.LLDoubleEntry> entrySet() {
        return this._map.extractValues();
    }

    public long getMaxRow() {
        return this._maxRow;
    }

    public long getMaxColumn() {
        return this._maxCol;
    }

    public void aggregate(long row, long col, double w) {
        this._map.addValue(row, col, w);
        this._maxRow = Math.max(this._maxRow, row);
        this._maxCol = Math.max(this._maxCol, col);
    }

    public MatrixBlock toMatrixBlock(int rlen, int clen) {
        int nnz = this._map.size();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz);
        MatrixBlock mb = new MatrixBlock(rlen, clen, sparse, nnz);
        if (sparse) {
            for (LongLongDoubleHashMap.LLDoubleEntry e : this._map.extractValues()) {
                double value = e.value;
                int rix = (int)e.key1;
                int cix = (int)e.key2;
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.appendValue(rix - 1, cix - 1, value);
            }
            mb.sortSparseRows();
        } else {
            for (LongLongDoubleHashMap.LLDoubleEntry e : this._map.extractValues()) {
                double value = e.value;
                int rix = (int)e.key1;
                int cix = (int)e.key2;
                if (value == 0.0 || rix > rlen || cix > clen) continue;
                mb.quickSetValue(rix - 1, cix - 1, value);
            }
        }
        return mb;
    }
}

