/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class ReaderTextCSVParallel
extends MatrixReader {
    private CSVFileFormatProperties _props = null;
    private int _numThreads = OptimizerUtils.getParallelTextReadParallelism();
    private SplitOffsetInfos _offsets = null;

    public ReaderTextCSVParallel(CSVFileFormatProperties props) {
        this._props = props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = FileSystem.get((Configuration)job);
        Path path = new Path(fname);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, this._numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        ReaderTextCSVParallel.checkValidInputFile(fs, path);
        MatrixBlock ret = this.computeCSVSizeAndCreateOutputMatrixBlock(splits, path, job, this._props.hasHeader(), this._props.getDelim(), estnnz);
        rlen = ret.getNumRows();
        clen = ret.getNumColumns();
        this.readCSVMatrixFromHDFS(splits, path, job, ret, rlen, clen, brlen, bclen, this._props.hasHeader(), this._props.getDelim(), this._props.isFill(), this._props.getFillValue());
        ret.examSparsity();
        if (rlen > 0L && rlen != (long)ret.getNumRows()) {
            throw new DMLRuntimeException("Read matrix inconsistent with given meta data: expected nrow=" + rlen + ", real nrow=" + ret.getNumRows());
        }
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        throw new DMLRuntimeException("Not implemented yet.");
    }

    private void readCSVMatrixFromHDFS(InputSplit[] splits, Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean hasHeader, String delim, boolean fill, double fillValue) throws IOException {
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        ExecutorService pool = Executors.newFixedThreadPool(this._numThreads);
        try {
            ArrayList<CSVReadTask> tasks = new ArrayList<CSVReadTask>();
            int splitCount = 0;
            for (InputSplit split : splits) {
                tasks.add(new CSVReadTask(split, this._offsets, informat, job, dest, rlen, clen, hasHeader, delim, fill, fillValue, splitCount++));
            }
            pool.invokeAll(tasks);
            pool.shutdown();
            long lnnz = 0L;
            for (CSVReadTask rt : tasks) {
                lnnz += rt.getPartialNnz();
                if (rt.getReturnCode()) continue;
                Exception err = rt.getException();
                throw new IOException("Read task for csv input failed: " + err.toString(), err);
            }
            dest.setNonZeros(lnnz);
        }
        catch (Exception e) {
            throw new IOException("Threadpool issue, while parallel read.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixBlock computeCSVSizeAndCreateOutputMatrixBlock(InputSplit[] splits, Path path, JobConf job, boolean hasHeader, String delim, long estnnz) throws IOException, DMLRuntimeException {
        int nrow = 0;
        int ncol = 0;
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        LongWritable key = new LongWritable();
        Text oneLine = new Text();
        RecordReader reader = informat.getRecordReader(splits[0], job, Reporter.NULL);
        try {
            if (reader.next((Object)key, (Object)oneLine)) {
                String cellStr = oneLine.toString().trim();
                ncol = StringUtils.countMatches((String)cellStr, (String)delim) + 1;
            }
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        try {
            ExecutorService pool = Executors.newFixedThreadPool(this._numThreads);
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (InputSplit split : splits) {
                tasks.add(new CountRowsTask(split, informat, job, hasHeader));
                hasHeader = false;
            }
            pool.invokeAll(tasks);
            pool.shutdown();
            this._offsets = new SplitOffsetInfos(tasks.size());
            for (CountRowsTask rt : tasks) {
                if (!rt.getReturnCode()) {
                    throw new IOException("Count task for csv input failed: " + rt.getErrMsg());
                }
                this._offsets.setOffsetPerSplit(tasks.indexOf(rt), nrow);
                this._offsets.setLenghtPerSplit(tasks.indexOf(rt), rt.getRowCount());
                nrow += rt.getRowCount();
            }
        }
        catch (Exception e) {
            throw new IOException("Threadpool Error " + e.getMessage(), e);
        }
        return ReaderTextCSVParallel.createOutputMatrixBlock(nrow, ncol, nrow, ncol, estnnz, true, true);
    }

    private static class CSVReadTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private SplitOffsetInfos _splitoffsets = null;
        private boolean _sparse = false;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private MatrixBlock _dest = null;
        private long _rlen = -1L;
        private long _clen = -1L;
        private boolean _isFirstSplit = false;
        private boolean _hasHeader = false;
        private boolean _fill = false;
        private double _fillValue = 0.0;
        private String _delim = null;
        private int _splitCount = 0;
        private boolean _rc = true;
        private Exception _exception = null;
        private long _nnz;

        public CSVReadTask(InputSplit split, SplitOffsetInfos offsets, TextInputFormat informat, JobConf job, MatrixBlock dest, long rlen, long clen, boolean hasHeader, String delim, boolean fill, double fillValue, int splitCount) {
            this._split = split;
            this._splitoffsets = offsets;
            this._sparse = dest.isInSparseFormat();
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._rlen = rlen;
            this._clen = clen;
            this._isFirstSplit = splitCount == 0;
            this._hasHeader = hasHeader;
            this._fill = fill;
            this._fillValue = fillValue;
            this._delim = delim;
            this._rc = true;
            this._splitCount = splitCount;
        }

        public boolean getReturnCode() {
            return this._rc;
        }

        public Exception getException() {
            return this._exception;
        }

        public long getPartialNnz() {
            return this._nnz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            int row = 0;
            int col = 0;
            double cellValue = 0.0;
            long lnnz = 0L;
            try {
                RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
                LongWritable key = new LongWritable();
                Text value = new Text();
                if (this._isFirstSplit && this._hasHeader) {
                    reader.next((Object)key, (Object)value);
                }
                boolean noFillEmpty = false;
                row = this._splitoffsets.getOffsetPerSplit(this._splitCount);
                try {
                    if (this._sparse) {
                        while (reader.next((Object)key, (Object)value)) {
                            String cellStr = value.toString().trim();
                            String[] parts = IOUtilFunctions.split(cellStr, this._delim);
                            col = 0;
                            for (String part : parts) {
                                if ((part = part.trim()).isEmpty()) {
                                    noFillEmpty |= !this._fill;
                                    cellValue = this._fillValue;
                                } else {
                                    cellValue = IOUtilFunctions.parseDoubleParallel(part);
                                }
                                if (cellValue != 0.0) {
                                    this._dest.appendValue(row, col, cellValue);
                                    ++lnnz;
                                }
                                ++col;
                            }
                            IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, this._fill, noFillEmpty);
                            IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, this._clen);
                            ++row;
                        }
                    } else {
                        while (reader.next((Object)key, (Object)value)) {
                            String cellStr = value.toString().trim();
                            String[] parts = IOUtilFunctions.split(cellStr, this._delim);
                            col = 0;
                            for (String part : parts) {
                                if ((part = part.trim()).isEmpty()) {
                                    noFillEmpty |= !this._fill;
                                    cellValue = this._fillValue;
                                } else {
                                    cellValue = IOUtilFunctions.parseDoubleParallel(part);
                                }
                                if (cellValue != 0.0) {
                                    this._dest.setValueDenseUnsafe(row, col, cellValue);
                                    ++lnnz;
                                }
                                ++col;
                            }
                            IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, this._fill, noFillEmpty);
                            IOUtilFunctions.checkAndRaiseErrorCSVNumColumns(this._split.toString(), cellStr, parts, this._clen);
                            ++row;
                        }
                    }
                    if (row != this._splitoffsets.getOffsetPerSplit(this._splitCount) + this._splitoffsets.getLenghtPerSplit(this._splitCount)) {
                        throw new IOException("Incorrect number of rows (" + row + ") found in delimited file (" + (this._splitoffsets.getOffsetPerSplit(this._splitCount) + this._splitoffsets.getLenghtPerSplit(this._splitCount)) + "): " + value);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            catch (Exception ex) {
                this._rc = false;
                this._exception = ex;
                if (row < 0 || (long)(row + 1) > this._rlen || col < 0 || (long)(col + 1) > this._clen) {
                    String errMsg = "CSV cell [" + (row + 1) + "," + (col + 1) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "]. " + ex.getMessage();
                    throw new IOException(errMsg, this._exception);
                }
                String errMsg = "Unable to read matrix in text CSV format. " + ex.getMessage();
                throw new IOException(errMsg, this._exception);
            }
            this._nnz = lnnz;
            return null;
        }
    }

    private static class CountRowsTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private boolean _rc = true;
        private String _errMsg = null;
        private int _nrows = -1;
        private boolean _hasHeader = false;

        public CountRowsTask(InputSplit split, TextInputFormat informat, JobConf job, boolean hasHeader) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._nrows = 0;
            this._hasHeader = hasHeader;
        }

        public boolean getReturnCode() {
            return this._rc;
        }

        public int getRowCount() {
            return this._nrows;
        }

        public String getErrMsg() {
            return this._errMsg;
        }

        @Override
        public Object call() throws Exception {
            RecordReader reader = this._informat.getRecordReader(this._split, this._job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text oneLine = new Text();
            try {
                if (this._hasHeader) {
                    reader.next((Object)key, (Object)oneLine);
                }
                while (reader.next((Object)key, (Object)oneLine)) {
                    ++this._nrows;
                }
            }
            catch (Exception e) {
                this._rc = false;
                this._errMsg = "RecordReader error CSV format. split: " + this._split.toString() + e.getMessage();
                throw new IOException(this._errMsg);
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return null;
        }
    }

    private static class SplitOffsetInfos {
        private int[] offsetPerSplit = null;
        private int[] lenghtPerSplit = null;

        public SplitOffsetInfos(int numSplits) {
            this.lenghtPerSplit = new int[numSplits];
            this.offsetPerSplit = new int[numSplits];
        }

        public int getLenghtPerSplit(int split) {
            return this.lenghtPerSplit[split];
        }

        public void setLenghtPerSplit(int split, int r) {
            this.lenghtPerSplit[split] = r;
        }

        public int getOffsetPerSplit(int split) {
            return this.offsetPerSplit[split];
        }

        public void setOffsetPerSplit(int split, int o) {
            this.offsetPerSplit[split] = o;
        }
    }
}

