/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.io.FrameWriterBinaryBlock;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.util.MapReduceTool;

public class FrameWriterBinaryBlockParallel
extends FrameWriterBinaryBlock {
    @Override
    protected void writeBinaryBlockFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException, DMLRuntimeException {
        int blen = ConfigurationManager.getBlocksize();
        int numPartFiles = Math.max((int)(OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)blen, (long)blen, rlen * clen) / InfrastructureAnalyzer.getHDFSBlockSize()), 1);
        int numThreads = OptimizerUtils.getParallelBinaryWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeBinaryBlockFrameToHDFS(path, job, src, rlen, clen);
            return;
        }
        MapReduceTool.createDirIfNotExistOnHDFS(path.toString(), "777");
        FileSystem fs = FileSystem.get((Configuration)job);
        try {
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            ArrayList<WriteFileTask> tasks = new ArrayList<WriteFileTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)blen / (double)numThreads) * blen;
            int i = 0;
            while (i < numThreads & (long)(i * blklen) < rlen) {
                Path newPath = new Path(path, String.format("0-m-%05d", i));
                tasks.add(new WriteFileTask(newPath, job, fs, src, i * blklen, Math.min((i + 1) * blklen, (int)rlen), blen));
                ++i;
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : rt) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of binary block input.", e);
        }
    }

    private class WriteFileTask
    implements Callable<Object> {
        private Path _path = null;
        private JobConf _job = null;
        private FileSystem _fs = null;
        private FrameBlock _src = null;
        private int _blen = -1;
        private int _rl = -1;
        private int _ru = -1;

        public WriteFileTask(Path path, JobConf job, FileSystem fs, FrameBlock src, int rl, int ru, int blen) {
            this._path = path;
            this._fs = fs;
            this._job = job;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._blen = blen;
        }

        @Override
        public Object call() throws Exception {
            FrameWriterBinaryBlockParallel.this.writeBinaryBlockFrameToSequenceFile(this._path, this._job, this._fs, this._src, this._blen, this._rl, this._ru);
            return null;
        }
    }
}

