/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class FrameReader {
    public abstract FrameBlock readFrameFromHDFS(String var1, Expression.ValueType[] var2, String[] var3, long var4, long var6) throws IOException, DMLRuntimeException;

    public FrameBlock readFrameFromHDFS(String fname, Expression.ValueType[] schema, long rlen, long clen) throws IOException, DMLRuntimeException {
        return this.readFrameFromHDFS(fname, schema, this.getDefColNames(schema.length), rlen, clen);
    }

    public FrameBlock readFrameFromHDFS(String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        return this.readFrameFromHDFS(fname, this.getDefSchema(clen), this.getDefColNames(clen), rlen, clen);
    }

    public abstract FrameBlock readFrameFromInputStream(InputStream var1, Expression.ValueType[] var2, String[] var3, long var4, long var6) throws IOException, DMLRuntimeException;

    public FrameBlock readFrameFromInputStream(InputStream is, Expression.ValueType[] schema, long rlen, long clen) throws IOException, DMLRuntimeException {
        return this.readFrameFromInputStream(is, schema, this.getDefColNames(schema.length), rlen, clen);
    }

    public FrameBlock readFrameFromInputStream(InputStream is, long rlen, long clen) throws IOException, DMLRuntimeException {
        return this.readFrameFromInputStream(is, this.getDefSchema(clen), this.getDefColNames(clen), rlen, clen);
    }

    public Expression.ValueType[] getDefSchema(long clen) throws IOException, DMLRuntimeException {
        int lclen = Math.max((int)clen, 1);
        return UtilFunctions.nCopies(lclen, Expression.ValueType.STRING);
    }

    public String[] getDefColNames(long clen) throws IOException, DMLRuntimeException {
        return clen < 0L ? new String[]{} : FrameBlock.createColNames((int)clen);
    }

    public static Path[] getSequenceFilePaths(FileSystem fs, Path file) throws IOException {
        Path[] ret = null;
        if (fs.isDirectory(file)) {
            FileStatus[] dStatus;
            LinkedList<Path> tmp = new LinkedList<Path>();
            for (FileStatus fdStatus : dStatus = fs.listStatus(file)) {
                if (fdStatus.getPath().getName().startsWith("_")) continue;
                tmp.add(fdStatus.getPath());
            }
            ret = tmp.toArray(new Path[0]);
        } else {
            ret = new Path[]{file};
        }
        return ret;
    }

    protected static FrameBlock createOutputFrameBlock(Expression.ValueType[] schema, String[] names, long nrow) throws IOException, DMLRuntimeException {
        if (!OptimizerUtils.isValidCPDimensions(schema, names)) {
            throw new DMLRuntimeException("Schema and names to be define with equal size.");
        }
        FrameBlock ret = new FrameBlock(schema, names);
        ret.ensureAllocatedColumns((int)nrow);
        return ret;
    }

    protected static Expression.ValueType[] createOutputSchema(Expression.ValueType[] schema, long ncol) {
        if (schema.length == 1 && ncol > 1L) {
            return UtilFunctions.nCopies((int)ncol, schema[0]);
        }
        return schema;
    }

    protected static String[] createOutputNames(String[] names, long ncol) {
        if ((long)names.length != ncol) {
            return FrameBlock.createColNames((int)ncol);
        }
        return names;
    }

    protected static void checkValidInputFile(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("File " + path.toString() + " does not exist on HDFS/LFS.");
        }
        if (MapReduceTool.isFileEmpty(fs, path.toString())) {
            throw new EOFException("Empty input file " + path.toString() + ".");
        }
    }
}

