/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.data;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBlock;

public class PartitionedBroadcast<T extends CacheBlock>
implements Serializable {
    private static final long serialVersionUID = 7041959166079438401L;
    protected static final long BROADCAST_PARTSIZE = 0xC800000L;
    private Broadcast<PartitionedBlock<T>>[] _pbc = null;

    public PartitionedBroadcast() {
    }

    public PartitionedBroadcast(Broadcast<PartitionedBlock<T>>[] broadcasts) {
        this._pbc = broadcasts;
    }

    public Broadcast<PartitionedBlock<T>>[] getBroadcasts() {
        return this._pbc;
    }

    public int getNumRowBlocks() {
        return ((PartitionedBlock)this._pbc[0].value()).getNumRowBlocks();
    }

    public int getNumColumnBlocks() {
        return ((PartitionedBlock)this._pbc[0].value()).getNumColumnBlocks();
    }

    public static int computeBlocksPerPartition(long rlen, long clen, long brlen, long bclen) {
        return (int)Math.floor(0xC800000L / Math.min(rlen, brlen) / Math.min(clen, bclen));
    }

    public T getBlock(int rowIndex, int colIndex) throws DMLRuntimeException {
        int pix = 0;
        if (this._pbc.length > 1) {
            PartitionedBlock tmp = (PartitionedBlock)this._pbc[0].value();
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(tmp.getNumRows(), tmp.getNumCols(), tmp.getNumRowsPerBlock(), tmp.getNumColumnsPerBlock());
            int ix = (rowIndex - 1) * tmp.getNumColumnBlocks() + (colIndex - 1);
            pix = ix / numPerPart;
        }
        return ((PartitionedBlock)this._pbc[pix].value()).getBlock(rowIndex, colIndex);
    }

    public T sliceOperations(long rl, long ru, long cl, long cu, T block) throws DMLRuntimeException {
        CacheBlock ret = null;
        for (Broadcast<PartitionedBlock<T>> bc : this._pbc) {
            PartitionedBlock pm = (PartitionedBlock)bc.value();
            T tmp = pm.sliceOperations(rl, ru, cl, cu, block);
            if (ret != null) {
                ret.merge((CacheBlock)tmp, false);
                continue;
            }
            ret = (CacheBlock)tmp;
        }
        return (T)ret;
    }

    public void destroy() {
        for (Broadcast<PartitionedBlock<T>> bvar : this._pbc) {
            SparkExecutionContext.cleanupBroadcastVariable(bvar);
        }
    }
}

