/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.codegen.LibSpoofPrimitives;
import org.apache.sysml.runtime.codegen.SpoofCellwise;
import org.apache.sysml.runtime.codegen.SpoofMultiAggregate;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.codegen.SpoofOuterProduct;
import org.apache.sysml.runtime.codegen.SpoofRowwise;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import scala.Tuple2;

public class SpoofSPInstruction
extends SPInstruction {
    private final Class<?> _class;
    private final byte[] _classBytes;
    private final CPOperand[] _in;
    private final CPOperand _out;

    public SpoofSPInstruction(Class<?> cls, byte[] classBytes, CPOperand[] in, CPOperand out, String opcode, String str) {
        super(opcode, str);
        this._class = cls;
        this._classBytes = classBytes;
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.SpoofFused;
        this._in = in;
        this._out = out;
    }

    public static SpoofSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> inlist = new ArrayList<CPOperand>();
        Class<?> cls = CodegenUtils.getClass(parts[1]);
        byte[] classBytes = CodegenUtils.getClassData(parts[1]);
        String opcode = parts[0] + CodegenUtils.createInstance(cls).getSpoofType();
        for (int i = 2; i < parts.length - 2; ++i) {
            inlist.add(new CPOperand(parts[i]));
        }
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        return new SpoofSPInstruction(cls, classBytes, inlist.toArray(new CPOperand[0]), out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        ArrayList<String> bcVars = new ArrayList<String>();
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this._in[0].getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this._in[0].getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
        ArrayList<PartitionedBroadcast<MatrixBlock>> bcMatrices = new ArrayList<PartitionedBroadcast<MatrixBlock>>();
        ArrayList<ScalarObject> scalars = new ArrayList<ScalarObject>();
        for (int i = 1; i < this._in.length; ++i) {
            if (this._in[i].getDataType() == Expression.DataType.MATRIX) {
                bcMatrices.add(sec.getBroadcastForVariable(this._in[i].getName()));
                bcVars.add(this._in[i].getName());
                continue;
            }
            if (this._in[i].getDataType() != Expression.DataType.SCALAR) continue;
            scalars.add(sec.getScalarInput(this._in[i].getName(), this._in[i].getValueType(), this._in[i].isLiteral()));
        }
        if (this._class.getSuperclass() == SpoofCellwise.class) {
            SpoofCellwise op = (SpoofCellwise)CodegenUtils.createInstance(this._class);
            AggregateOperator aggop = SpoofSPInstruction.getAggregateOperator(op.getAggOp());
            if (this._out.getDataType() == Expression.DataType.MATRIX) {
                out = in.mapPartitionsToPair((PairFlatMapFunction)new CellwiseFunction(this._class.getName(), this._classBytes, bcMatrices, scalars), true);
                if (op.getCellType() == SpoofCellwise.CellType.ROW_AGG && mcIn.getCols() > (long)mcIn.getColsPerBlock()) {
                    out = (long)out.partitions().size() > mcIn.getNumRowBlocks() ? RDDAggregateUtils.aggByKeyStable(out, aggop, (int)mcIn.getNumRowBlocks(), false) : RDDAggregateUtils.aggByKeyStable(out, aggop, false);
                }
                sec.setRDDHandleForVariable(this._out.getName(), out);
                sec.addLineageRDD(this._out.getName(), this._in[0].getName());
                for (String bcVar : bcVars) {
                    sec.addLineageBroadcast(this._out.getName(), bcVar);
                }
                this.updateOutputMatrixCharacteristics(sec, op);
            } else {
                out = in.mapPartitionsToPair((PairFlatMapFunction)new CellwiseFunction(this._class.getName(), this._classBytes, bcMatrices, scalars), true);
                MatrixBlock tmpMB = RDDAggregateUtils.aggStable(out, aggop);
                sec.setVariable(this._out.getName(), new DoubleObject(tmpMB.getValue(0, 0)));
            }
        } else {
            if (this._class.getSuperclass() == SpoofMultiAggregate.class) {
                SpoofMultiAggregate op = (SpoofMultiAggregate)CodegenUtils.createInstance(this._class);
                SpoofCellwise.AggOp[] aggOps = op.getAggOps();
                MatrixBlock tmpMB = (MatrixBlock)in.mapToPair((PairFunction)new MultiAggregateFunction(this._class.getName(), this._classBytes, bcMatrices, scalars)).values().fold((Object)new MatrixBlock(), (Function2)new MultiAggAggregateFunction(aggOps));
                sec.setMatrixOutput(this._out.getName(), tmpMB);
                return;
            }
            if (this._class.getSuperclass() == SpoofOuterProduct.class) {
                if (this._out.getDataType() == Expression.DataType.MATRIX) {
                    SpoofOperator op = CodegenUtils.createInstance(this._class);
                    SpoofOuterProduct.OutProdType type = ((SpoofOuterProduct)op).getOuterProdType();
                    this.updateOutputMatrixCharacteristics(sec, op);
                    MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this._out.getName());
                    out = in.mapPartitionsToPair((PairFlatMapFunction)new OuterProductFunction(this._class.getName(), this._classBytes, bcMatrices, scalars), true);
                    if (type == SpoofOuterProduct.OutProdType.LEFT_OUTER_PRODUCT || type == SpoofOuterProduct.OutProdType.RIGHT_OUTER_PRODUCT) {
                        out = (long)in.partitions().size() > mcOut.getNumRowBlocks() * mcOut.getNumColBlocks() ? RDDAggregateUtils.sumByKeyStable(out, (int)(mcOut.getNumRowBlocks() * mcOut.getNumColBlocks()), false) : RDDAggregateUtils.sumByKeyStable(out, false);
                    }
                    sec.setRDDHandleForVariable(this._out.getName(), out);
                    sec.addLineageRDD(this._out.getName(), this._in[0].getName());
                    for (String bcVar : bcVars) {
                        sec.addLineageBroadcast(this._out.getName(), bcVar);
                    }
                } else {
                    out = in.mapPartitionsToPair((PairFlatMapFunction)new OuterProductFunction(this._class.getName(), this._classBytes, bcMatrices, scalars), true);
                    MatrixBlock tmp = RDDAggregateUtils.sumStable(out);
                    sec.setVariable(this._out.getName(), new DoubleObject(tmp.getValue(0, 0)));
                }
            } else {
                if (this._class.getSuperclass() == SpoofRowwise.class) {
                    SpoofRowwise op = (SpoofRowwise)CodegenUtils.createInstance(this._class);
                    RowwiseFunction fmmc = new RowwiseFunction(this._class.getName(), this._classBytes, bcMatrices, scalars, (int)mcIn.getCols());
                    out = in.mapPartitionsToPair((PairFlatMapFunction)fmmc, op.getRowType() == SpoofRowwise.RowType.ROW_AGG);
                    if (op.getRowType().isColumnAgg()) {
                        MatrixBlock tmpMB = RDDAggregateUtils.sumStable(out);
                        sec.setMatrixOutput(this._out.getName(), tmpMB);
                    } else {
                        if (op.getRowType() == SpoofRowwise.RowType.ROW_AGG && mcIn.getCols() > (long)mcIn.getColsPerBlock()) {
                            out = (long)out.partitions().size() > mcIn.getNumRowBlocks() ? RDDAggregateUtils.sumByKeyStable(out, (int)mcIn.getNumRowBlocks(), false) : RDDAggregateUtils.sumByKeyStable(out, false);
                        }
                        sec.setRDDHandleForVariable(this._out.getName(), out);
                        sec.addLineageRDD(this._out.getName(), this._in[0].getName());
                        for (String bcVar : bcVars) {
                            sec.addLineageBroadcast(this._out.getName(), bcVar);
                        }
                        this.updateOutputMatrixCharacteristics(sec, op);
                    }
                    return;
                }
                throw new DMLRuntimeException("Operator " + this._class.getSuperclass() + " is not supported on Spark");
            }
        }
    }

    private void updateOutputMatrixCharacteristics(SparkExecutionContext sec, SpoofOperator op) throws DMLRuntimeException {
        if (op instanceof SpoofCellwise) {
            MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this._in[0].getName());
            MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this._out.getName());
            if (((SpoofCellwise)op).getCellType() == SpoofCellwise.CellType.ROW_AGG) {
                mcOut.set(mcIn.getRows(), 1L, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            } else if (((SpoofCellwise)op).getCellType() == SpoofCellwise.CellType.NO_AGG) {
                mcOut.set(mcIn);
            }
        } else if (op instanceof SpoofOuterProduct) {
            MatrixCharacteristics mcIn1 = sec.getMatrixCharacteristics(this._in[0].getName());
            MatrixCharacteristics mcIn2 = sec.getMatrixCharacteristics(this._in[1].getName());
            MatrixCharacteristics mcIn3 = sec.getMatrixCharacteristics(this._in[2].getName());
            MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this._out.getName());
            SpoofOuterProduct.OutProdType type = ((SpoofOuterProduct)op).getOuterProdType();
            if (type == SpoofOuterProduct.OutProdType.CELLWISE_OUTER_PRODUCT) {
                mcOut.set(mcIn1.getRows(), mcIn1.getCols(), mcIn1.getRowsPerBlock(), mcIn1.getColsPerBlock());
            } else if (type == SpoofOuterProduct.OutProdType.LEFT_OUTER_PRODUCT) {
                mcOut.set(mcIn3.getRows(), mcIn3.getCols(), mcIn3.getRowsPerBlock(), mcIn3.getColsPerBlock());
            } else if (type == SpoofOuterProduct.OutProdType.RIGHT_OUTER_PRODUCT) {
                mcOut.set(mcIn2.getRows(), mcIn2.getCols(), mcIn2.getRowsPerBlock(), mcIn2.getColsPerBlock());
            }
        } else if (op instanceof SpoofRowwise) {
            MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this._in[0].getName());
            MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this._out.getName());
            SpoofRowwise.RowType type = ((SpoofRowwise)op).getRowType();
            if (type == SpoofRowwise.RowType.NO_AGG) {
                mcOut.set(mcIn);
            } else if (type == SpoofRowwise.RowType.ROW_AGG) {
                mcOut.set(mcIn.getRows(), 1L, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            } else if (type == SpoofRowwise.RowType.COL_AGG) {
                mcOut.set(1L, mcIn.getCols(), mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            } else if (type == SpoofRowwise.RowType.COL_AGG_T) {
                mcOut.set(mcIn.getCols(), 1L, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
            }
        }
    }

    public static AggregateOperator getAggregateOperator(SpoofCellwise.AggOp aggop) {
        if (aggop == SpoofCellwise.AggOp.SUM || aggop == SpoofCellwise.AggOp.SUM_SQ) {
            return new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), true, PartialAggregate.CorrectionLocationType.NONE);
        }
        if (aggop == SpoofCellwise.AggOp.MIN) {
            return new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MIN), false, PartialAggregate.CorrectionLocationType.NONE);
        }
        if (aggop == SpoofCellwise.AggOp.MAX) {
            return new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MAX), false, PartialAggregate.CorrectionLocationType.NONE);
        }
        return null;
    }

    private static class OuterProductFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8209188316939435099L;
        private ArrayList<PartitionedBroadcast<MatrixBlock>> _bcMatrices = null;
        private ArrayList<ScalarObject> _scalars = null;
        private byte[] _classBytes = null;
        private String _className = null;
        private SpoofOperator _op = null;

        public OuterProductFunction(String className, byte[] classBytes, ArrayList<PartitionedBroadcast<MatrixBlock>> bcMatrices, ArrayList<ScalarObject> scalars) throws DMLRuntimeException {
            this._className = className;
            this._classBytes = classBytes;
            this._bcMatrices = bcMatrices;
            this._scalars = scalars;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg) throws Exception {
            if (this._op == null) {
                Class<?> loadedClass = CodegenUtils.getClass(this._className, this._classBytes);
                this._op = CodegenUtils.createInstance(loadedClass);
            }
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            while (arg.hasNext()) {
                Tuple2<MatrixIndexes, MatrixBlock> tmp = arg.next();
                MatrixIndexes ixIn = (MatrixIndexes)tmp._1();
                MatrixBlock blkIn = (MatrixBlock)tmp._2();
                MatrixBlock blkOut = new MatrixBlock();
                ArrayList<MatrixBlock> inputs = new ArrayList<MatrixBlock>();
                inputs.add(blkIn);
                inputs.add(this._bcMatrices.get(0).getBlock((int)ixIn.getRowIndex(), 1));
                inputs.add(this._bcMatrices.get(1).getBlock((int)ixIn.getColumnIndex(), 1));
                if (((SpoofOuterProduct)this._op).getOuterProdType() == SpoofOuterProduct.OutProdType.AGG_OUTER_PRODUCT) {
                    ScalarObject obj = this._op.execute(inputs, this._scalars, 1);
                    blkOut.reset(1, 1);
                    blkOut.quickSetValue(0, 0, obj.getDoubleValue());
                } else {
                    this._op.execute(inputs, this._scalars, blkOut);
                }
                ret.add(new Tuple2((Object)this.createOutputIndexes(ixIn, this._op), (Object)blkOut));
            }
            return ret.iterator();
        }

        private MatrixIndexes createOutputIndexes(MatrixIndexes in, SpoofOperator spoofOp) {
            if (((SpoofOuterProduct)spoofOp).getOuterProdType() == SpoofOuterProduct.OutProdType.LEFT_OUTER_PRODUCT) {
                return new MatrixIndexes(in.getColumnIndex(), 1L);
            }
            if (((SpoofOuterProduct)spoofOp).getOuterProdType() == SpoofOuterProduct.OutProdType.RIGHT_OUTER_PRODUCT) {
                return new MatrixIndexes(in.getRowIndex(), 1L);
            }
            return in;
        }
    }

    private static class MultiAggAggregateFunction
    implements Function2<MatrixBlock, MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = 5978731867787952513L;
        private SpoofCellwise.AggOp[] _ops = null;

        public MultiAggAggregateFunction(SpoofCellwise.AggOp[] ops) {
            this._ops = ops;
        }

        public MatrixBlock call(MatrixBlock arg0, MatrixBlock arg1) throws Exception {
            if (arg0.getNumRows() <= 0 || arg0.getNumColumns() <= 0) {
                arg0.copy(arg1);
                return arg0;
            }
            if (arg1.getNumRows() <= 0 || arg1.getNumColumns() <= 0) {
                return arg0;
            }
            SpoofMultiAggregate.aggregatePartialResults(this._ops, arg0, arg1);
            return arg0;
        }
    }

    private static class MultiAggregateFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -5224519291577332734L;
        private ArrayList<PartitionedBroadcast<MatrixBlock>> _vectors = null;
        private ArrayList<ScalarObject> _scalars = null;
        private byte[] _classBytes = null;
        private String _className = null;
        private SpoofOperator _op = null;

        public MultiAggregateFunction(String className, byte[] classBytes, ArrayList<PartitionedBroadcast<MatrixBlock>> bcMatrices, ArrayList<ScalarObject> scalars) throws DMLRuntimeException {
            this._className = className;
            this._classBytes = classBytes;
            this._vectors = bcMatrices;
            this._scalars = scalars;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> arg) throws Exception {
            if (this._op == null) {
                Class<?> loadedClass = CodegenUtils.getClass(this._className, this._classBytes);
                this._op = CodegenUtils.createInstance(loadedClass);
            }
            ArrayList<MatrixBlock> inputs = this.getVectorInputsFromBroadcast((MatrixBlock)arg._2(), (MatrixIndexes)arg._1());
            MatrixBlock blkOut = new MatrixBlock();
            this._op.execute(inputs, this._scalars, blkOut);
            return new Tuple2(arg._1(), (Object)blkOut);
        }

        private ArrayList<MatrixBlock> getVectorInputsFromBroadcast(MatrixBlock blkIn, MatrixIndexes ixIn) throws DMLRuntimeException {
            ArrayList<MatrixBlock> ret = new ArrayList<MatrixBlock>();
            ret.add(blkIn);
            for (PartitionedBroadcast<MatrixBlock> in : this._vectors) {
                int rowIndex = (int)((long)in.getNumRowBlocks() >= ixIn.getRowIndex() ? ixIn.getRowIndex() : 1L);
                int colIndex = (int)((long)in.getNumColumnBlocks() >= ixIn.getColumnIndex() ? ixIn.getColumnIndex() : 1L);
                ret.add(in.getBlock(rowIndex, colIndex));
            }
            return ret;
        }
    }

    private static class CellwiseFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8209188316939435099L;
        private ArrayList<PartitionedBroadcast<MatrixBlock>> _vectors = null;
        private ArrayList<ScalarObject> _scalars = null;
        private byte[] _classBytes = null;
        private String _className = null;
        private SpoofOperator _op = null;

        public CellwiseFunction(String className, byte[] classBytes, ArrayList<PartitionedBroadcast<MatrixBlock>> bcMatrices, ArrayList<ScalarObject> scalars) throws DMLRuntimeException {
            this._className = className;
            this._classBytes = classBytes;
            this._vectors = bcMatrices;
            this._scalars = scalars;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg) throws Exception {
            if (this._op == null) {
                Class<?> loadedClass = CodegenUtils.getClass(this._className, this._classBytes);
                this._op = CodegenUtils.createInstance(loadedClass);
            }
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            while (arg.hasNext()) {
                Tuple2<MatrixIndexes, MatrixBlock> tmp = arg.next();
                MatrixIndexes ixIn = (MatrixIndexes)tmp._1();
                MatrixBlock blkIn = (MatrixBlock)tmp._2();
                MatrixIndexes ixOut = ixIn;
                MatrixBlock blkOut = new MatrixBlock();
                ArrayList<MatrixBlock> inputs = this.getVectorInputsFromBroadcast(blkIn, ixIn);
                if (((SpoofCellwise)this._op).getCellType() == SpoofCellwise.CellType.FULL_AGG) {
                    ScalarObject obj = this._op.execute(inputs, this._scalars, 1);
                    blkOut.reset(1, 1);
                    blkOut.quickSetValue(0, 0, obj.getDoubleValue());
                } else {
                    if (((SpoofCellwise)this._op).getCellType() == SpoofCellwise.CellType.ROW_AGG) {
                        ixOut = new MatrixIndexes(ixOut.getRowIndex(), 1L);
                    }
                    this._op.execute(inputs, this._scalars, blkOut);
                }
                ret.add(new Tuple2((Object)ixOut, (Object)blkOut));
            }
            return ret.iterator();
        }

        private ArrayList<MatrixBlock> getVectorInputsFromBroadcast(MatrixBlock blkIn, MatrixIndexes ixIn) throws DMLRuntimeException {
            ArrayList<MatrixBlock> ret = new ArrayList<MatrixBlock>();
            ret.add(blkIn);
            for (PartitionedBroadcast<MatrixBlock> in : this._vectors) {
                int rowIndex = (int)((long)in.getNumRowBlocks() >= ixIn.getRowIndex() ? ixIn.getRowIndex() : 1L);
                int colIndex = (int)((long)in.getNumColumnBlocks() >= ixIn.getColumnIndex() ? ixIn.getColumnIndex() : 1L);
                ret.add(in.getBlock(rowIndex, colIndex));
            }
            return ret;
        }
    }

    private static class RowwiseFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -7926980450209760212L;
        private final ArrayList<PartitionedBroadcast<MatrixBlock>> _vectors;
        private final ArrayList<ScalarObject> _scalars;
        private final byte[] _classBytes;
        private final String _className;
        private final int _clen;
        private SpoofRowwise _op = null;

        public RowwiseFunction(String className, byte[] classBytes, ArrayList<PartitionedBroadcast<MatrixBlock>> bcMatrices, ArrayList<ScalarObject> scalars, int clen) throws DMLRuntimeException {
            this._className = className;
            this._classBytes = classBytes;
            this._vectors = bcMatrices;
            this._scalars = scalars;
            this._clen = clen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg) throws Exception {
            MatrixBlock blkOut;
            if (this._op == null) {
                Class<?> loadedClass = CodegenUtils.getClass(this._className, this._classBytes);
                this._op = (SpoofRowwise)CodegenUtils.createInstance(loadedClass);
            }
            LibSpoofPrimitives.setupThreadLocalMemory(this._op.getNumIntermediates(), this._clen);
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            boolean aggIncr = this._op.getRowType().isColumnAgg();
            MatrixBlock matrixBlock = blkOut = aggIncr ? new MatrixBlock() : null;
            while (arg.hasNext()) {
                Tuple2<MatrixIndexes, MatrixBlock> e = arg.next();
                MatrixIndexes ixIn = (MatrixIndexes)e._1();
                MatrixBlock blkIn = (MatrixBlock)e._2();
                int rowIx = (int)ixIn.getRowIndex();
                ArrayList<MatrixBlock> inputs = this.getVectorInputsFromBroadcast(blkIn, rowIx);
                blkOut = aggIncr ? blkOut : new MatrixBlock();
                this._op.execute(inputs, this._scalars, blkOut, false, aggIncr);
                if (aggIncr) continue;
                MatrixIndexes ixOut = new MatrixIndexes(ixIn.getRowIndex(), this._op.getRowType() != SpoofRowwise.RowType.NO_AGG ? 1L : ixIn.getColumnIndex());
                ret.add(new Tuple2((Object)ixOut, (Object)blkOut));
            }
            LibSpoofPrimitives.cleanupThreadLocalMemory();
            if (aggIncr) {
                ret.add(new Tuple2((Object)new MatrixIndexes(1L, 1L), (Object)blkOut));
            }
            return ret.iterator();
        }

        private ArrayList<MatrixBlock> getVectorInputsFromBroadcast(MatrixBlock blkIn, int rowIndex) throws DMLRuntimeException {
            ArrayList<MatrixBlock> ret = new ArrayList<MatrixBlock>();
            ret.add(blkIn);
            for (PartitionedBroadcast<MatrixBlock> vector : this._vectors) {
                ret.add(vector.getBlock(vector.getNumRowBlocks() >= rowIndex ? rowIndex : 1, 1));
            }
            return ret;
        }
    }
}

