/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.instructions.spark.functions.CopyFrameBlockFunction;
import org.apache.sysml.runtime.instructions.spark.functions.CreateSparseBlockFunction;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CheckpointSPInstruction
extends UnarySPInstruction {
    private StorageLevel _level = null;

    public CheckpointSPInstruction(Operator op, CPOperand in, CPOperand out, StorageLevel level, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.Checkpoint;
        this._level = level;
    }

    public static CheckpointSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        StorageLevel level = StorageLevel.fromString((String)parts[3]);
        return new CheckpointSPInstruction(null, in, out, level, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        if (sec.getVariable(this.input1.getName()) == null || sec.getVariable(this.input1.getName()) instanceof BooleanObject) {
            sec.setVariable(this.input1.getName(), new BooleanObject(false));
            sec.setVariable(this.output.getName(), new BooleanObject(false));
            return;
        }
        JavaPairRDD in = sec.getRDDHandleForVariable(this.input1.getName(), InputInfo.BinaryBlockInputInfo);
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this.input1.getName());
        JavaPairRDD out = null;
        if (!in.getStorageLevel().equals((Object)this._level)) {
            boolean coalesce;
            int numPartitions = SparkUtils.getNumPreferredPartitions(mcIn, in);
            boolean bl = coalesce = 1.2 * (double)numPartitions < (double)in.getNumPartitions() && !SparkUtils.isHashPartitioned(in);
            if (coalesce) {
                out = in.coalesce(numPartitions);
            } else if (this.input1.getDataType() == Expression.DataType.MATRIX) {
                out = SparkUtils.copyBinaryBlockMatrix((JavaPairRDD<MatrixIndexes, MatrixBlock>)in, false);
            } else if (this.input1.getDataType() == Expression.DataType.FRAME) {
                out = in.mapValues((Function)new CopyFrameBlockFunction(false));
            }
            if (this.input1.getDataType() == Expression.DataType.MATRIX && OptimizerUtils.checkSparseBlockCSRConversion(mcIn)) {
                out = out.mapValues((Function)new CreateSparseBlockFunction(SparseBlock.Type.CSR));
            }
            out = out.persist(this._level);
        } else {
            out = in;
        }
        CacheableData<?> cd = sec.getCacheableData(this.input1.getName());
        if (out != in) {
            RDDObject inro = cd.getRDDHandle();
            RDDObject outro = new RDDObject(out, this.output.getName());
            outro.setCheckpointRDD(true);
            outro.addLineageChild(inro);
            cd.setRDDHandle(outro);
        }
        sec.setVariable(this.output.getName(), cd);
    }
}

