/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixBVectorBuiltinSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixMatrixBuiltinSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixScalarBuiltinSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.RightScalarOperator;

public abstract class BuiltinBinarySPInstruction
extends BinarySPInstruction {
    public BuiltinBinarySPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.BuiltinBinary;
    }

    public static BuiltinBinarySPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = null;
        boolean isBroadcast = false;
        BinaryM.VectorType vtype = null;
        Builtin func = null;
        if (str.startsWith("SPARK\u00b0map")) {
            String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
            InstructionUtils.checkNumFields(parts, 5);
            opcode = parts[0];
            in1.split(parts[1]);
            in2.split(parts[2]);
            out.split(parts[3]);
            func = Builtin.getBuiltinFnObject(opcode.substring(3));
            vtype = BinaryM.VectorType.valueOf(parts[5]);
            isBroadcast = true;
        } else {
            opcode = BuiltinBinarySPInstruction.parseBinaryInstruction(str, in1, in2, out);
            func = Builtin.getBuiltinFnObject(opcode);
        }
        if (func == null) {
            throw new DMLRuntimeException("Failed to create builtin value function for opcode: " + opcode);
        }
        if (in1.getDataType() != in2.getDataType()) {
            return new MatrixScalarBuiltinSPInstruction(new RightScalarOperator(func, 0.0), in1, in2, out, opcode, str);
        }
        if (isBroadcast) {
            return new MatrixBVectorBuiltinSPInstruction((Operator)new BinaryOperator(func), in1, in2, out, vtype, opcode, str);
        }
        return new MatrixMatrixBuiltinSPInstruction(new BinaryOperator(func), in1, in2, out, opcode, str);
    }
}

