/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ZeroOutOperator;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ZeroOutInstruction
extends UnaryMRInstructionBase {
    public IndexRange indexRange = null;
    private IndexRange tempRange = new IndexRange(-1L, -1L, -1L, -1L);
    public boolean complementary = false;

    public ZeroOutInstruction(Operator op, byte in, byte out, IndexRange rng, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.ZeroOut;
        this.instString = istr;
        this.indexRange = rng;
    }

    public static ZeroOutInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 6);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("zeroOut")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a zeroout: " + str);
        }
        byte in = Byte.parseByte(parts[1]);
        IndexRange rng = new IndexRange(UtilFunctions.parseToLong(parts[2]), UtilFunctions.parseToLong(parts[3]), UtilFunctions.parseToLong(parts[4]), UtilFunctions.parseToLong(parts[5]));
        byte out = Byte.parseByte(parts[6]);
        return new ZeroOutInstruction(new ZeroOutOperator(), in, out, rng, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                this.tempRange = UtilFunctions.getSelectedRangeForZeroOut(in, blockRowFactor, blockColFactor, this.indexRange);
                if (this.tempRange.rowStart == -1L && this.complementary) {
                    return;
                }
                if (this.tempRange.rowStart == -1L && !this.complementary) {
                    cachedValues.add(this.output, in);
                    return;
                }
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                OperationsOnMatrixValues.performZeroOut(in.getIndexes(), in.getValue(), out.getIndexes(), out.getValue(), this.tempRange, this.complementary);
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }
}

