/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.DiagIndex;
import org.apache.sysml.runtime.functionobjects.RevIndex;
import org.apache.sysml.runtime.functionobjects.SwapIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;

public class ReorgInstruction
extends UnaryMRInstructionBase {
    private MatrixCharacteristics _mcIn = null;
    private boolean _outputEmptyBlocks = true;

    public ReorgInstruction(ReorgOperator op, byte in, byte out, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Reorg;
        this.instString = istr;
    }

    public void setInputMatrixCharacteristics(MatrixCharacteristics in) {
        this._mcIn = in;
    }

    public void setOutputEmptyBlocks(boolean flag) {
        this._outputEmptyBlocks = flag;
    }

    public static ReorgInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        if (opcode.equalsIgnoreCase("r'")) {
            return new ReorgInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject()), in, out, str);
        }
        if (opcode.equalsIgnoreCase("rev")) {
            return new ReorgInstruction(new ReorgOperator(RevIndex.getRevIndexFnObject()), in, out, str);
        }
        if (opcode.equalsIgnoreCase("rdiag")) {
            return new ReorgInstruction(new ReorgOperator(DiagIndex.getDiagIndexFnObject()), in, out, str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a ReorgInstruction: " + str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                int startRow = 0;
                int startColumn = 0;
                int length = 0;
                if (((ReorgOperator)this.optr).fn instanceof DiagIndex) {
                    IndexedMatrixValue out;
                    boolean V2M = this._mcIn.getRows() == 1L || this._mcIn.getCols() == 1L;
                    long rlen = Math.max(this._mcIn.getRows(), this._mcIn.getCols());
                    if (!V2M && in.getIndexes().getRowIndex() != in.getIndexes().getColumnIndex()) continue;
                    if (V2M) {
                        out = cachedValues.holdPlace(this.output, valueClass);
                        OperationsOnMatrixValues.performReorg(in.getIndexes(), in.getValue(), out.getIndexes(), out.getValue(), (ReorgOperator)this.optr, startRow, startColumn, length);
                        if (!this._outputEmptyBlocks || !valueClass.equals(MatrixBlock.class)) continue;
                        long diagIndex = out.getIndexes().getRowIndex();
                        long brlen = Math.max(this._mcIn.getRowsPerBlock(), this._mcIn.getColsPerBlock());
                        long numRowBlocks = rlen / brlen + (long)(rlen % brlen != 0L ? 1 : 0);
                        for (long rc = 1L; rc <= numRowBlocks; ++rc) {
                            if (rc == diagIndex) continue;
                            IndexedMatrixValue emptyIndexValue = cachedValues.holdPlace(this.output, valueClass);
                            int lbrlen = (int)(rc * brlen <= rlen ? brlen : rlen % brlen);
                            emptyIndexValue.getIndexes().setIndexes(rc, diagIndex);
                            emptyIndexValue.getValue().reset(lbrlen, out.getValue().getNumColumns(), true);
                        }
                        continue;
                    }
                    out = cachedValues.holdPlace(this.output, valueClass);
                    out.getIndexes().setIndexes(in.getIndexes().getRowIndex(), 1L);
                    in.getValue().reorgOperations((ReorgOperator)this.optr, out.getValue(), startRow, startColumn, length);
                    continue;
                }
                if (((ReorgOperator)this.optr).fn instanceof RevIndex) {
                    ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
                    LibMatrixReorg.rev(in, this._mcIn.getRows(), this._mcIn.getRowsPerBlock(), out);
                    for (IndexedMatrixValue outblk : out) {
                        cachedValues.add(this.output, outblk);
                    }
                    continue;
                }
                IndexedMatrixValue out = cachedValues.holdPlace(this.output, valueClass);
                OperationsOnMatrixValues.performReorg(in.getIndexes(), in.getValue(), out.getIndexes(), out.getValue(), (ReorgOperator)this.optr, startRow, startColumn, length);
            }
        }
    }
}

