/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class RandInstruction
extends DataGenMRInstruction {
    private double minValue;
    private double maxValue;
    private double sparsity;
    private String probabilityDensityFunction;
    private String pdfParams;
    private long seed = 0L;

    public RandInstruction(Operator op, byte in, byte out, long rows, long cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String probabilityDensityFunction, String params, String baseDir, String istr) {
        super(op, Hop.DataGenMethod.RAND, in, out, rows, cols, rpb, cpb, baseDir);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Rand;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sparsity = sparsity;
        this.seed = seed;
        this.probabilityDensityFunction = probabilityDensityFunction;
        this.pdfParams = params;
        this.instString = istr;
    }

    public String getPdfParams() {
        return this.pdfParams;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public String getProbabilityDensityFunction() {
        return this.probabilityDensityFunction;
    }

    public long getSeed() {
        return this.seed;
    }

    public static RandInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 13);
        String[] parts = InstructionUtils.getInstructionParts(str);
        Operator op = null;
        byte input = Byte.parseByte(parts[1]);
        byte output = Byte.parseByte(parts[2]);
        long rows = Double.valueOf(parts[3]).longValue();
        long cols = Double.valueOf(parts[4]).longValue();
        int rpb = Integer.parseInt(parts[5]);
        int cpb = Integer.parseInt(parts[6]);
        double minValue = Double.parseDouble(parts[7]);
        double maxValue = Double.parseDouble(parts[8]);
        double sparsity = Double.parseDouble(parts[9]);
        long seed = Long.parseLong(parts[10]);
        String baseDir = parts[11];
        String pdf = parts[12];
        String pdfParams = parts[13];
        return new RandInstruction(op, input, output, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, pdf, pdfParams, baseDir, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
    }
}

