/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CSVReblockInstruction
extends ReblockInstruction {
    public String delim = ",";
    public boolean hasHeader = false;
    public boolean fill = true;
    public double fillValue = 0.0;

    public CSVReblockInstruction(Operator op, byte in, byte out, int br, int bc, boolean hasHeader, String delim, boolean fll, double mv, String istr) {
        super(op, in, out, br, bc, false, istr);
        this.delim = delim;
        this.fill = fll;
        this.fillValue = mv;
        this.hasHeader = hasHeader;
    }

    public Instruction clone(byte in) {
        String[] parts = this.instString.split("\u00b0");
        String[] in1f = parts[2].split("\u00b7");
        in1f[0] = Byte.toString(in);
        parts[2] = in1f[0] + "\u00b7" + in1f[1] + "\u00b7" + in1f[2];
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            sb.append("\u00b0");
            sb.append(parts[i]);
        }
        return CSVReblockInstruction.parseInstruction(sb.toString());
    }

    public static CSVReblockInstruction parseInstruction(String str) {
        Operator op = null;
        String[] s = str.split("\u00b0");
        String[] in1f = s[2].split("\u00b7");
        byte input = Byte.parseByte(in1f[0]);
        String[] outf = s[3].split("\u00b7");
        byte output = Byte.parseByte(outf[0]);
        int brlen = Integer.parseInt(s[4]);
        int bclen = Integer.parseInt(s[5]);
        boolean hasHeader = Boolean.parseBoolean(s[6]);
        String delim = s[7];
        boolean fill = Boolean.parseBoolean(s[8]);
        double missingValue = Double.parseDouble(s[9]);
        return new CSVReblockInstruction(op, input, output, brlen, bclen, hasHeader, delim, fill, missingValue, str);
    }
}

