/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.COV;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.COVOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CM_N_COVInstruction
extends UnaryMRInstructionBase {
    public CM_N_COVInstruction(Operator op, byte in, byte out, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.CM_N_COV;
        this.instString = istr;
    }

    public static CM_N_COVInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("cm")) {
            byte in = Byte.parseByte(parts[1]);
            int cst = Integer.parseInt(parts[2]);
            byte out = Byte.parseByte(parts[3]);
            if (cst > 4 || cst < 0 || cst == 1) {
                throw new DMLRuntimeException("constant for central moment has to be 0, 2, 3, or 4");
            }
            CMOperator.AggregateOperationTypes opType = CMOperator.getCMAggOpType(cst);
            CMOperator cm = new CMOperator(CM.getCMFnObject(opType), opType);
            return new CM_N_COVInstruction(cm, in, out, str);
        }
        if (opcode.equalsIgnoreCase("cov")) {
            byte in = Byte.parseByte(parts[1]);
            byte out = Byte.parseByte(parts[2]);
            COVOperator cov = new COVOperator(COV.getCOMFnObject());
            return new CM_N_COVInstruction(cov, in, out, str);
        }
        throw new DMLRuntimeException("unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        throw new DMLRuntimeException("no processInstruction for AggregateInstruction!");
    }
}

